#include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/Vehicle.h>
#include <dingus/kernel/SystemClock.h>

const float _nBallStartHeight( 12.0f );
const float _nNextBallHeight( 4.0f );
const float _nBallMass( 42.34f ); // Araz: 242.34f
const float _nCornerConeMass( 1.0f );	// Static obj. anyway...
const float _nCornerConeStartHeight( 1.0f );

CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 7.0f, 2.0f, 140.0f );
	}
}
CMyGame::~CMyGame()
{
}

std::string Int2String( int nNumber, int nMinimumSimbols ) {
	assert( nMinimumSimbols>=1 && nMinimumSimbols<=11 );
	char sk[12];
	sprintf(sk,"%i",nNumber);
	std::string cNumberInString( sk );
	while( cNumberInString.length() < nMinimumSimbols )
		cNumberInString = "0" + cNumberInString;
	return cNumberInString;
}

void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
		const char* name = i ? "monster" : "goom";
		mVehicle[i] = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );
		
		for( int j = 0; j < 4; j++ )
			mVehicle[ i ]->getWheel( j ).setColor( i & 1 ? 0x30303080 : 0x30803030 );

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
	}

	for( i = 0; i < _nBallsCount; i++ ) {
		CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass("Sphere");
		std::string strBallName = "sfera" + Int2String( i, 2 );
		bool bBlueBall = i & 1 == 1;
		/*m_pBalls[ i ] = new CBall( bBlueBall, strBallName.c_str(), *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), level.getVisThing(), _nBallMass );
		level.getThingEntities().addEntity( m_pBalls[ i ] );
		m_pBalls[ i ]->getMatrix() = level.getMarkers().getValue("ballStart");
		m_pBalls[ i ]->getMatrix().getOrigin().y += _nBallStartHeight + i * _nNextBallHeight; // HACK
		m_pBalls[ i ]->getPhysComp().setMatrixPORed(m_pBalls[ i ]->getMatrix() );
		m_pBalls[ i ]->attach();
		level.getBounds().addBoundable( m_pBalls[ i ]->getWorldMatrix(), m_pBalls[ i ] );
		m_pBalls[ i ]->setColor( i & 1 ? 0x30303080 : 0x30803030 );*/

		CBall* pBall = new CBall( bBlueBall, strBallName.c_str(), *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), level.getVisThing(), _nBallMass );
		level.getThingEntities().addEntity(pBall);
		pBall->getMatrix() = level.getMarkers().getValue("ballStart");
		pBall->getMatrix().getOrigin().y += _nBallStartHeight + i * _nNextBallHeight; // HACK
		pBall->getPhysComp().setMatrixPORed(pBall->getMatrix() );
		pBall->attach();
		level.getBounds().addBoundable( pBall->getWorldMatrix(), pBall );
		pBall->setColor( i & 1 ? 0x30303080 : 0x30803030 );
		m_vBalls.push_back(pBall);
	}

	for( i = 0; i < _nCornersTotal; i++ ) {
		CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass("o_cone");
		std::string strCornerName = "corner" + Int2String( i, 1 );
		m_pCornerFlags[ i ] = new CThingEntity( strCornerName.c_str(), *clazz, (1<<COL_ENTITY_STATIC)|(1<<COL_ENTITY_THING), level.getVisThing(), _nCornerConeMass );
		level.getThingEntities().addEntity( m_pCornerFlags[ i ] );
		m_pCornerFlags[ i ]->getMatrix() = level.getMarkers().getValue( strCornerName.c_str() );
		m_pCornerFlags[ i ]->getMatrix().getOrigin().y += _nCornerConeStartHeight; // HACK
		m_pCornerFlags[ i ]->getPhysComp().setMatrixPORed(m_pCornerFlags[ i ]->getMatrix() );
		m_pCornerFlags[ i ]->attach();
		level.getBounds().addBoundable( m_pCornerFlags[ i ]->getWorldMatrix(), m_pCornerFlags[ i ] );
	}
}


void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel( "../data/script/levels/futbolas.lua" );
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( dingus::CSystemClock::getInstance().getLastPerformDuration(), SVector3(0,0,0), true );
		char buf[100];
		sprintf( buf, "score: %i", mScore[i] );
		float height = 0.06f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, 0xFFFFFFFF
		);
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
	}
}

void CMyGame::onUpdate()
{
	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
	int nvKeyBrake[VEHICLES] = { VK_CONTROL, VK_SPACE };

	for( int i = 0; i < VEHICLES; ++i ) {
		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "start2" : "start1");
			mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
			mVehicle[i]->attach();
			//++mScore[VEHICLES-i-1];
			continue;
		}
		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp[i]) )
			accel += 1;
		if( GetAsyncKeyState(keyDown[i]) )
			accel -= 1;

		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft[i]) )
			turn += 1;
		if( GetAsyncKeyState(keyRight[i]) )
			turn -= 1;

		bool bBrake = false;

		if (GetAsyncKeyState(nvKeyBrake[i])) {
			bBrake = true;
			accel = 0.0f;	// Do not accelerate on brake.
		}

		mVehicle[i]->control(accel, turn, bBrake);
	}

	CLevel &rLevel = CGameInfo::getInstance().getLevel();
	SMatrix4x4 sMatrix = rLevel.getMarkers().getValue( "corner0" );
	int nInitX = sMatrix.getOrigin().x;
	int nInitZ = sMatrix.getOrigin().z;
	int nMinX( nInitX ), nMinZ( nInitZ ), nMaxX( nInitX ), nMaxZ( nInitZ );
	for( i = 0; i < 4; i++ ) {
		std::string strCornerConeName = "corner" + Int2String( i, 1 );
		sMatrix = rLevel.getMarkers().getValue( strCornerConeName );
		if( nMinX > sMatrix.getOrigin().x ) nMinX = sMatrix.getOrigin().x;
		if( nMinZ > sMatrix.getOrigin().z ) nMinZ = sMatrix.getOrigin().z;
		if( nMaxX < sMatrix.getOrigin().x ) nMaxX = sMatrix.getOrigin().x;
		if( nMaxZ < sMatrix.getOrigin().z ) nMaxZ = sMatrix.getOrigin().z;
	}

	std::vector<CBall*>::iterator vbi;

	for( vbi = m_vBalls.begin(); vbi != m_vBalls.end(); vbi++ ) {
		CPhysicsable& phys = (*vbi)->getPhysComp().getPhysicsable();
		SVector3 v = phys.getAngularVel();
		phys.addTorque( -v * 10.0f );
		if ((*vbi)->IsOutOfBounds()) {
			(*vbi)->detach();
			(*vbi)->SetOutOfBounds(false);
			(*vbi)->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("ballStart");
			(*vbi)->getMatrix().getOrigin().y += _nBallStartHeight;
			(*vbi)->getPhysComp().setMatrixPORed((*vbi)->getMatrix() );
			(*vbi)->attach();
		} else {
			int nBallX = (*vbi)->getMatrix().getOrigin().x;
			int nBallZ = (*vbi)->getMatrix().getOrigin().z;
			if( nBallX >= nMinX && nBallX <= nMaxX && nBallZ >= nMinZ && nBallZ <= nMaxZ ) {
				// Ball is in position.
				int nPlayerNr = (*vbi)->IsBlue() ? 1 : 0;
				++mScore[nPlayerNr];
				(*vbi)->detach();
				(*vbi)->SetOutOfBounds(false);
				(*vbi)->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("ballStart");
				(*vbi)->getMatrix().getOrigin().y += _nBallStartHeight;
				(*vbi)->getPhysComp().setMatrixPORed((*vbi)->getMatrix() );
				(*vbi)->attach();
			}
		}
	}

	CGameInfo::getInstance().getLevel().update();
}
