function makePart( tex, mode )
	local fxs = { 'textured.fx', 'texturedAlpha.fx' }
	local layers = { 0, 1 }
	return { texture=tex, fx=fxs[mode], layer=layers[mode] }
end
function makeMesh( mesh, pts )
	return { name=mesh, parts=pts }
end
modeSimple = 1
modeAlpha = 2

partsRoad = {
	makePart( 'road01.jpg', modeSimple ),
}
partsSquare = {
	makePart( 'square01.jpg', modeSimple ),
}

staticMeshes = {
makeMesh( 'Border', partsRoad ),
makeMesh( 'Square', partsSquare ),
makeMesh( 'SquareUp', partsSquare ),
makeMesh( 'SquareCorner1', partsSquare ),
makeMesh( 'SquareCorner2', partsSquare ),
}

thingMeshes = {
makeMesh( 'o_cone', { makePart( 'cone01.png', modeSimple ) } ),
makeMesh( 'o_marker', { makePart( 'rgb01.png', modeSimple ) } ),
makeMesh( 'Sphere', { makePart( 'rgb01.png', modeSimple ) } ),
}
