#include "stdafx.h"
#pragma hdrstop

#include "BaseGame.h"
#include <unco/kernel/Contexts.h>
#include <unco/kernel/AppContext.h>
#include <dingus/kernel/SystemClock.h>
#include <dingus/physics-ode/PhysicsContext.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <unco/component/vis/VisibilityComponent.h>

#include <dingus/resource/IndexBufferBundle.h>
#include <dingus/resource/TextureBundle.h>


unco::SStartupParams CBaseGame::getStartupParams()
{
	unco::SStartupParams p;
	p.windowTitle			= "IWAK by rtfb & Bilbas @ LTGameJam2003";
	p.dataPath				= "../data/";
	p.windowWidth			= 640;
	p.windowHeight			= 480;
	p.minColorBits			= 4;
	p.minAlphaBits			= 0;
	p.minZBits				= 16;
	p.minStencilBits		= 0;
	p.usesZBuffer			= true;
	p.startFullscreen		= false;
	p.showCursorFullscreen	= false;
	return p;
}

bool CBaseGame::checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT format )
{
	//if( (caps.VertexShaderVersion < D3DVS_VERSION(1,1)) && (behavior & D3DCREATE_HARDWARE_VERTEXPROCESSING) )
	//	return false;
	return true;
}


CBaseGame::CBaseGame()
{
}

void CBaseGame::initialize()
{
	//
	// vis

	//unco::CContexts::getVisCtx().addDB( DB_OVERLAY, *(new dingus::CDummyVisibilityDB()) );
	unco::CVisibilityComponent* vis = new unco::CVisibilityComponent();
	mGlobalContainer.addComponent( *vis );

	//
	// IB quads

	dingus::CResourceId ibQuadsID = "ibQuads";
	dingus::CIndexBufferBundle::getInstance().registerIB( ibQuadsID, 16000*6, D3DFMT_INDEX16, mIBFillerQuads );

	//
	// billboards

	mBillboards = new unco::CBillboardsComponent(
		*dingus::CIndexBufferBundle::getInstance().getResourceById(ibQuadsID),
		"bill.fx", dingus::CRenderContext::LAYER_COUNT-1 );
	mGlobalContainer.addComponent( *mBillboards );
	vis->addListener( *mBillboards );

	//
	// text renderer

	mTextRenderer = new unco::CTextRenderer(
		mBillboards->getBillboards(),
		*dingus::CTextureBundle::getInstance().getResourceById("font1.png"),
		dingus::SVector2(0,0), dingus::SVector2(1,1), '!', 9, 11 );

	//
	// physics params

	dingus::CPhysicsContext& phys = unco::CContexts::getPhysicsCtx();
	phys.setGravity( SVector3(0,-9.81f,0) );
	phys.setERP( 0.6f ); // Araz: none
	phys.setCFM( 0.0003f );

	dWorldSetAutoDisableSteps( phys, 10 );
	dWorldSetAutoDisableThreshold( phys, 0.008 );

	//
	// global collision listener

	dingus::CCollisionContext& col = unco::CContexts::getCollisionCtx();
	col.setGlobalColListener( &mCommonColListener );

	//
	// viewing stuff

	mRenderTarget.setClearValues( true, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER, 0xFF204060, 1.0f, 0 );
	mCamera = new unco::CCamera( mRenderTarget );
	mGlobalContainer.addEntity( mCamera );

	//
	// attach globals

	mGlobalContainer.attach();

	//
	// initialize game

	onInitialize();
}

void CBaseGame::onBeginPerform()
{
	unco::CAppContext& appctx = unco::CAppContext::getInstance();
	mCamera->setProjectionParams(
		0.20f * 3.1415927f,
		unco::CAppContext::getInstance().getWindowAspect(),
		1.0f, 500.0f
	);
	mRenderTarget.setSettingViewport( false );
	mCamera->activate();

	onBeginCycle();
}

void CBaseGame::onEndPerform()
{
	onEndCycle();
}

void CBaseGame::perform()
{
	mGlobalContainer.update();
	onUpdate();
}

void CBaseGame::shutdown()
{
}
