#ifndef __BASE_GAME_H
#define __BASE_GAME_H

#include <dingus/resource/IndexBufferFillers.h>

#include <unco/kernel/EngineApplication.h>
#include <unco/helpers/RenderTarget.h>
#include <unco/entity/Camera.h>
#include <unco/component/gfx/BillboardsComponent.h>
#include <unco/helpers/TextRenderer.h>
#include <unco/entity/Container.h>
#include <dingus/visibility/VisibilityContext.h>

#include "CommonCollisionListener.h"



class CBaseGame : public unco::IEngineApplication {
public:
	CBaseGame();

	virtual void onBeginCycle() = 0;
	virtual void onEndCycle() = 0;
	virtual void onUpdate() = 0;
	virtual void onInitialize() = 0;

	dingus::CRenderableBillboards& getBillboards() { return mBillboards->getBillboards(); }
	unco::CTextRenderer& getTextRenderer() { return *mTextRenderer; }

	const unco::CCamera& getCamera() const { return *mCamera; }
	unco::CCamera& getCamera() { return *mCamera; }
	
public:
	// IEngineApplication
	virtual unco::SStartupParams getStartupParams();
	virtual bool checkDevice( const D3DCAPS9& caps, DWORD behavior, D3DFORMAT format );
	virtual void initialize();
	virtual void perform();
	virtual void shutdown();
	virtual void onBeginPerform();
	virtual void onEndPerform();

private:
	unco::TEntityContainer		mGlobalContainer;

	// portal stuff
	unco::CRenderTarget			mRenderTarget;
	unco::CCamera*				mCamera;

	// collision handler
	CCommonCollisionListener	mCommonColListener;

	// billboards, text renderer
	dingus::CIBFillerQuads			mIBFillerQuads;
	unco::CBillboardsComponent*		mBillboards;
	unco::CTextRenderer*			mTextRenderer;
};


#endif
