#ifndef __BASE_ENTITY_H
#define __BASE_ENTITY_H

#include "EntityClass.h"
#include "../level/LevelBounds.h"


class CBaseEntity : public unco::CNamedEntity, public ILevelBoundListener {
public:
	typedef std::vector<unco::CMeshComponent*>	TMeshCompVector;

public:
	CBaseEntity( const std::string& name, const CEntityClass& clazz,
		int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp );
	CBaseEntity( const std::string& name, const CEntityClass& clazz,
		int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp,
		dingus::CCollidableContainer& colContainer );
	virtual ~CBaseEntity();

	CEntityClass const& getClass() const { return *mClass; }

	const TMeshCompVector& getMeshes() const { return mMeshes; }
	TMeshCompVector& getMeshes() { return mMeshes; }

	void setCullMode( D3DCULL cull ) { mCullMode = cull; }
	D3DCULL getCullMode() const { return mCullMode; }

	void setColor( const D3DXCOLOR& color ) { mColor = color; }

	virtual bool onLevelBound() {
		detach();
		discard();
		return true;
	}

private:
	void	createMeshes();
	
private:
	CEntityClass const*				mClass;
	dingus::CCollidableContainer*	mColContainer;
	TMeshCompVector					mMeshes;
	D3DCULL							mCullMode;
	D3DXCOLOR						mColor;
	unco::CVisibilityComponent*		mVisComp;
	bool	mExternalColContainer;
};


#endif
