#include "../stdafx.h"
#pragma hdrstop

#include "EntityClass.h"
#include <dingus/resource/CollisionMeshBundle.h>
#include <dingus/collider-ode/Collidable.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <unco/kernel/Contexts.h>


// --------------------------------------------------------------------------

SMeshPart::SMeshPart()
:	textureID(""),
	fxID(""),
	renderLayer(0)
{
}

SMeshPart::SMeshPart( SMeshPart const& rhs )
:	textureID(rhs.textureID),
	fxID(rhs.fxID),
	renderLayer(rhs.renderLayer)
{
}

SMeshPart const& SMeshPart::operator=( SMeshPart const& rhs )
{
	textureID = rhs.textureID;
	fxID = rhs.fxID;
	renderLayer = rhs.renderLayer;
	return *this;
}


// --------------------------------------------------------------------------

CEntityClass::CEntityClass( const std::string& name )
:	mName(name)
{
}

dingus::CCollidableContainer& CEntityClass::createColComponents( unco::CEntity& forEntity, int catBits, int colBits, bool flipCull ) const
{
	dingus::CCollidableContainer* container = new dingus::CSimpleCollidableContainer( NULL );
	createColComponents( forEntity, catBits, colBits, flipCull, *container );
	return *container;
}

void CEntityClass::createColComponents( unco::CEntity& forEntity, int catBits, int colBits, bool flipCull, dingus::CCollidableContainer& container ) const
{
	container.setCategoryBits( catBits );
	container.setCollideBits( colBits );
	dingus::CCollisionContext& ctx = unco::CContexts::getCollisionCtx();		
	if( !ctx.containsCollidable( container ) )
		ctx.addCollidable( container );
	for( int i = 0; i < mColParts.size(); ++i ) {
		const ICollidePartDesc* part = mColParts[i];
		assert( part );
		unco::CAbstractColComponent* comp = part->createColComp( forEntity.getWorldMatrix(), container, flipCull );
		assert( comp );
		forEntity.addComponent( *comp );
		comp->getCollidable().setUserData( &forEntity );
		comp->getCollidable().setCategoryBits( catBits );
		comp->getCollidable().setCollideBits( colBits );
	}
	// kind of HACK
	// if no collision components are present, create mesh component
	if( mColParts.empty() ) {
		unco::CAbstractColComponent* comp = new unco::CColMeshComponent( *dingus::CCollisionMeshBundle::getInstance().getResourceById( getName() + ".x" ), flipCull, forEntity.getWorldMatrix(), &container );
		forEntity.addComponent( *comp );
		comp->getCollidable().setUserData( &forEntity );
		comp->getCollidable().setCategoryBits( catBits );
		comp->getCollidable().setCollideBits( colBits );
	}
}

void CEntityClass::calcMass()
{
	dMassSetZero( &mMass );
	for( int i = 0; i < mColParts.size(); ++i ) {
		const ICollidePartDesc* part = mColParts[i];
		assert( part );
		part->calcMass( mMass, 1.0 );
	}
}
