#ifndef __LEVEL_H
#define __LEVEL_H

#include "../entity/BaseEntity.h"
#include "Markers.h"
#include "LevelBounds.h"


class CLevel {
public:
	typedef unco::CTypedNamedContainer<CBaseEntity>		TBaseEntityContainer;

public:
	CLevel();
	~CLevel();

	TBaseEntityContainer const& getStaticEntities() const { return mStaticEntities; }
	TBaseEntityContainer& getStaticEntities() { return mStaticEntities; }
	TBaseEntityContainer const& getThingEntities() const { return mThingEntities; }
	TBaseEntityContainer& getThingEntities() { return mThingEntities; }
	unco::TEntityContainer const& getStuff() const { return mStuff; }
	unco::TEntityContainer& getStuff() { return mStuff; }

	unco::CVisibilityComponent const& getVisStatic() const { return *mVisStatic; }
	unco::CVisibilityComponent& getVisStatic() { return *mVisStatic; }
	unco::CVisibilityComponent const& getVisThing() const { return *mVisThing; }
	unco::CVisibilityComponent& getVisThing() { return *mVisThing; }
	unco::CVisibilityComponent const& getVisStuff() const { return *mVisStuff; }
	unco::CVisibilityComponent& getVisStuff() { return *mVisStuff; }

	const CMarkers& getMarkers() const { return mMarkers; }
	CMarkers& getMarkers() { return mMarkers; }

	const CLevelBounds& getBounds() const { return *mBounds; }
	CLevelBounds& getBounds() { return *mBounds; }

	void update() {
		mStuff.update();
		mStaticEntities.update();
		mThingEntities.update();
		mBounds->update();
	}

private:
	TBaseEntityContainer		mStaticEntities;
	TBaseEntityContainer		mThingEntities;
	unco::TEntityContainer		mStuff;

	unco::CVisibilityComponent*	mVisStatic;
	unco::CVisibilityComponent*	mVisThing;
	unco::CVisibilityComponent*	mVisStuff;

	CMarkers		mMarkers;
	CLevelBounds*	mBounds;
};


#endif
