 #include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/entity/CollideClasses.h>
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/Vehicle.h>
#include <dingus/kernel/SystemClock.h>
#include <dingus/utils/Random.h>

#include <time.h>
#include <d3dx9math.h>



#define RVWEIGHT 0.9f
#define RTVWEIGHT (1 - RVWEIGHT)



static const std::string	gNames[] = {"Chemikeris",
										"Yolka",
										"Molka",
										"Mama",
										"DVD",
										"Bilbas",
										"Smogas",
										"Pelykanas",
										"Dzhonis"};

struct SIwakee
{
	float	alpha;
	int		index;
	bool	haveOne;
	bool	hasBeenFollowing;
} gIwakee = {0xff, 0, false, false};


float gFloorY;

CShiknosEntity::CShiknosEntity ( const std::string& name, const CEntityClass& clazz, unco::CVisibilityComponent& visComp, float mass )
: CBasePhysicsEntity( name, clazz, 1<<COL_ENTITY_THING, (1<<COL_ENTITY_STATIC)|(1<<COL_ENTITY_THING), false, visComp, mass) {};


void CShiknosEntity::internalUpdate()
{
}

bool CShiknosEntity::onLevelBound()
{
	detach();
	getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("start");
	getMatrix().getOrigin().y += 5.0f;
	getPhysComp().setMatrixPORed( getMatrix() ); // Araz
	attach();

	return false;
}



CMyGame::CMyGame()
{
	mFollowCamera = new CFollowCameraController( 7.0f, 2.0f, 4.0f );
}


CMyGame::~CMyGame()
{
	for (int i = 0; i < gNumNames; i++)
	{
		delete mRenderedNames[i];
	}
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	const SMatrix4x4& markM = level.getMarkers().getValue("start");
	CCamera& camera = getCamera();
	SMatrix4x4& m = camera.getMatrix();
	m = markM;
	m.getOrigin().y += 2.0f;
	m.getOrigin() -= m.getAxisZ()*10.0f;

	// HACK - create vehicle
	SMatrix4x4 carm = markM;
	carm.getOrigin().y += 1.0f;

	// Araz //mVehicle = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(/**/"goom"/**/), level.getVisStuff());

	mMiniMe = new CVehicle( "test2", *CGameInfo::getInstance().getClasses().getVehicleClass("monster"), level.getVisStuff());

	// Araz //level.getStuff().addEntity( mVehicle );
	level.getStuff().addEntity( mMiniMe );

	// Araz //mVehicle->getMatrix() = carm;
	mMiniMe->getMatrix() = m;

	// Araz //mVehicle->attach ();
	mMiniMe->attach ();
		
//	mShikna = (CShiknosEntity *)CGameInfo::getInstance().getLevel().getThingEntities().findEntity("Shikna000").get();
//	mSphere = (CShiknosEntity *)CGameInfo::getInstance().getLevel().getThingEntities().findEntity("Sphere000").get();

//	mShikna = new CShiknosEntity("shikna", *CGameInfo::getInstance().getClasses().getThingEntityClass("Shikna"), level.getVisThing());
//	mSphere = new CShiknosEntity("sfera", *CGameInfo::getInstance().getClasses().getThingEntityClass("sphere"), level.getVisThing());

	mShikna = new CShiknosEntity( "subine", *CGameInfo::getInstance().getClasses().getThingEntityClass("Shikna"), level.getVisThing(), 100.0f );
	mSphere = new CShiknosEntity( "sfera", *CGameInfo::getInstance().getClasses().getThingEntityClass("Sphere"), level.getVisThing(), 20.0f );
	
	// Araz
	level.getThingEntities().addEntity( mShikna );
	level.getThingEntities().addEntity( mSphere );
	// /Araz

	// Araz //level.getBounds().addBoundable( mVehicle->getWorldMatrix(), mVehicle);
	level.getBounds().addBoundable( mMiniMe->getWorldMatrix(), mMiniMe);

	level.getBounds().addBoundable( mShikna->getWorldMatrix(), mShikna );
	level.getBounds().addBoundable( mSphere->getWorldMatrix(), mSphere );

	// Araz //mVehicle->getMatrix ().getOrigin () = getCamera ().getMatrix ().getOrigin ();

	mShikna->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("pirmas");
	mShikna->getMatrix().getOrigin() += SVector3(10,2,-15); // Araz
	mSphere->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("antras");
	mSphere->getMatrix().getOrigin() += SVector3(-5,2,5); // Araz

	mShikna->attach();
	mSphere->attach();

	mFollowCamera->setAffectedMatrix( m );
	// Araz
	//mFollowCamera->setFollowMatrix( mVehicle->getWorldMatrix() );
	mFollowCamera->setFollowMatrix( mShikna->getWorldMatrix() );
}

void CMyGame::onInitialize()
{
	srand ((unsigned)time (NULL));
	mScore = 0;
	createLevel( "../data/script/levels/bliudas.lua" );

	// render all the names and save the images
	for (int i = 0; i < gNumNames; i++)
	{
		float height = 0.1f;
		char	buf[1024];
		sprintf (buf, "%s got a kick!", gNames[i].c_str ());
		float width = getTextRenderer().getWidth( buf, height );
		mRenderedNames[i] = getTextRenderer().renderTextHeight (buf,
					SVector2(-1.0f+(2.0f-width)/2.0f, -0.5f),
					height,
					0x00FFFFFF);
	}

//	mShikna = (CBasePhysicsEntity) *CGameInfo::getInstance().getLevel().getThingEntities().findEntity("Shikna");
}

void CMyGame::onBeginCycle()
{
	if (gIwakee.haveOne)
	{
		mFollowCamera->update( dingus::CSystemClock::getInstance().getLastPerformDuration(), SVector3(0,0,0), true );
	}
	else
	{
		//mFollowCamera->update( dingus::CSystemClock::getInstance().getLastPerformDuration(), SVector3(0,0,0), true );
		gIwakee.hasBeenFollowing = false;
	}


	// write the title
	char buf[100];
	sprintf (buf, "IWAK! %i points", mScore);
	float height = 0.1f; // 0.06f;
	float width = getTextRenderer().getWidth( buf, height );
	mScoreText = getTextRenderer().renderTextHeight( buf,
												SVector2(0.95f-width, -1), height, 0xFFFFFFFF);

	// write down the IWAKee
	if (gIwakee.haveOne)
	{
		gIwakee.alpha -= 0.3f;
		mRenderedNames[gIwakee.index]->setColor(0x00ffffff | (((int)gIwakee.alpha)<<24));

		if (gIwakee.alpha < 0.0f)
		{
			mRenderedNames[gIwakee.index]->setColor(0x00ffffff);
			gIwakee.haveOne = false;
			gIwakee.hasBeenFollowing = true;
/*			mMiniMe->getBody().getWorldMatrix() = getCamera().getWorldMatrix();
			mMiniMe->getMatrix() = getCamera().getMatrix();
			gIwakee.hasBeenFollowing = false;
			return;
*/		}
	}
}

void CMyGame::onEndCycle()
{
	delete mScoreText;
}

void CMyGame::onUpdate()
{
	int		keyKick = { VK_SPACE };
	int		keyCheat = { 'K'};
	float	accel = 0,
			nturn = 0,
			turnx = 0,
			turny = 0;

	// Araz
	//SVector3 asshole = mVehicle->getMatrix().getOrigin ();
	SVector3 asshole = mShikna->getMatrix().getOrigin ();
	SVector3 kicker = getCamera().getMatrix().getOrigin();
	SVector3 mighty_boot =  asshole - kicker;

//#if 0

	//if (!gIwakee.haveOne)
	//	handBreak(false);
	// Araz
	handBreak( gIwakee.haveOne );

/*	if ((mVehicle->getMatrix().getOrigin().y - gFloorY) > -0.05f)
	{
		mRenderedNames[gIwakee.index]->setColor(0x00ffffff);
		gIwakee.haveOne = false;
		gIwakee.hasBeenFollowing = true;
	}
/**/

	checkBounds();

//#endif

	collectInput(&accel, &nturn, &turnx, &turny);
	moveHero(accel, nturn, turnx, turny);

//#if 0

	static bool kicked1 = false;
	
	if (mighty_boot.length () < 3.14159f*3.14159f && GetAsyncKeyState(keyKick) && !kicked1)
	{
		/*
		 *	shiknos paspyrimo kodas
		 */
		kicked1 = true;
		performIwak();
		handBreak(true);
//		gFloorY = mVehicle->getMatrix().getOrigin().y;
	}								 
	else
	{
		/*
		 *	shiknos lakstymo kodas
		 */
		kicked1 = GetAsyncKeyState(keyKick) ? true : false;

		SVector3 dstPoint = mSphere->getMatrix().getOrigin();

		// Araz
		SVector3 runVector = mShikna->getMatrix ().getOrigin () - mMiniMe->getMatrix().getOrigin();
		SVector3 vehViewVector = mShikna->getMatrix().getAxisZ();
		SVector3 dstVector = dstPoint - mShikna->getMatrix().getOrigin();
		//SVector3 runVector = mVehicle->getBody().getMatrix ().getOrigin () - mMiniMe->getMatrix ().getOrigin();
		//SVector3 vehViewVector = mVehicle->getMatrix().getAxisZ();
		//SVector3 dstVector = dstPoint - mVehicle->getMatrix().getOrigin();

		// paspiria kamuoliuka, jaigu jau pakankamai arti privazhiavo. Kamuoliukas tada rieda,
		// ir shikna ji labiau vejasi.
		if (dstVector.length () < 30.0f) {
			// Araz
			//CBasePhysicsEntity &ent = (CBasePhysicsEntity&)*CGameInfo::getInstance().getLevel().getThingEntities().findEntity("subine").get();
			//ent.getPhysComp().getPhysicsable().addForce(vehViewVector * 50);
			//mShikna->getPhysComp().getPhysicsable().addForce(vehViewVector * 50);
			mSphere->getPhysComp().getPhysicsable().addForce(vehViewVector * 100);
			// /Araz
		}

		SVector3 newVector;

		if (runVector.length() < 20.0f)
		{
			newVector = runVector * RVWEIGHT - dstVector * RTVWEIGHT;
		}
		else
		{
			newVector = dstVector;
		}
		newVector.normalize();

//		newVector.y = 0;
		// Araz
		//mVehicle->getBody().getPhysComp().getPhysicsable().addForce(newVector*1000);
		//mShikna->getPhysComp().getPhysicsable().addForce(newVector*1000);
//		->getPhysComp().getPhysicsable().addForce(newVector*1000);

		mShikna->getPhysComp().getPhysicsable().addForce( mShikna->getPhysComp().getPhysicsable().getLinearVel() * (-20.0f) );
		mShikna->getPhysComp().getPhysicsable().addForce(newVector*200);

		mSphere->getPhysComp().getPhysicsable().addForce( mSphere->getPhysComp().getPhysicsable().getLinearVel() * (-2.0f) );

/*		vehViewVector.normalize();
		dstVector.normalize();
		float angle = acosf (vehViewVector.dot(dstVector));
//		dingus::CConsole::getChannel( "angle" ) << angle/PI*180 << dingus::endl;

		SMatrix4x4	mrot;
		D3DXMatrixRotationY( &mrot, angle );
		mVehicle->getMatrix() *=  mrot;
*/	}

	//
	// cheat:
	static bool kicked2 = false;
	if (GetAsyncKeyState(keyCheat) && !kicked2)
	{
			kicked2 = true;
			performIwak();
	}
	else
	{
		kicked2 = GetAsyncKeyState(keyCheat) ? true : false;
	}

//#endif
	
	CGameInfo::getInstance().getLevel().update();
}



void CMyGame::performIwak()
{
		++mScore;

		/*
		 *	Kickass!!!
		 */
		// Araz
		CPhysicsable& phys = mShikna->getPhysComp().getPhysicsable();
		SVector3 force;
		force  = mMiniMe->getWorldMatrix().getAxisZ() * random(800,1200);
		force += mMiniMe->getWorldMatrix().getAxisY() * random(-400,700);
		force += mMiniMe->getWorldMatrix().getAxisX() * random(-400,400);
		//phys.setLinearVel( SVector3(0,0,0) );
		//phys.setAngularVel( SVector3(0,0,0) );
		phys.addForce( force * 1000 );
		// /Araz

		/*
		 *	set a name to render
		 */
		if (!gIwakee.haveOne)
		{
			gIwakee.index = rand () % gNumNames;
			gIwakee.alpha = 255.0f;
			gIwakee.haveOne = true;
		}
}




void CMyGame::moveHero(float accel, float nturn, float turnx, float turny)
{
	if (gIwakee.haveOne)
		return;

	CCamera& camera = getCamera ();

	if (gIwakee.hasBeenFollowing)
	{
		mMiniMe->getBody().getWorldMatrix() = camera.getWorldMatrix();
		mMiniMe->getMatrix() = camera.getMatrix();
		gIwakee.hasBeenFollowing = false;
		return;
	}

	// pajudinam save pagal mashinos desnius
	mMiniMe->control (accel, nturn);
	
	// papildomai pakontroliuojam kamera
	/*
	SMatrix4x4 mrot;
	camera.getMatrix() = mMiniMe->getBody().getWorldMatrix();
	D3DXMatrixRotationY( &mrot, turny );
	camera.getMatrix() = mrot * camera.getMatrix();
	D3DXMatrixRotationX( &mrot, turnx );
	camera.getMatrix() = mrot * camera.getMatrix();
	*/
	
	// pakelia kamera shiek tiek aukshchiau
	camera.getMatrix() = mMiniMe->getBody().getWorldMatrix();
	camera.getMatrix().getOrigin().y += 2.0f;
}




void CMyGame::checkBounds()
{
	// patikrina, ar shikna neishleke ish mapo. Jei ishleke, grazhina i starto pozicija
	// Araz
	/*
	if( mShikna->isOutOfBounds() )
	{
		mShikna->detach();
		mShikna->setOutOfBounds( false );
		mShikna->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("start");
		mShikna->getMatrix().getOrigin().y += 1.0f;
		mShikna->attach();
	}
	*/
	
	// patikrina, ar pats zhaidejas neishleke ish mapo. Jei ishleke, grazhina i starto pozicija
	if( mMiniMe->isOutOfBounds() )
	{
		mMiniMe->detach();
		mMiniMe->setOutOfBounds( false );
		mMiniMe->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue("start");
		mMiniMe->getMatrix().getOrigin().y += 1.0f;
		mMiniMe->attach();
	}

//	mShikna->onLevelBound()

}




void CMyGame::collectInput (float *accel, float *nturn, float *turnx, float *turny)
{
	int keyUp			= {VK_UP};
	int keyDown			= {VK_DOWN};
	int keyLeft			= {VK_LEFT};
	int keyRight		= {VK_RIGHT};
	int keyCamUp		= {'W'};
	int keyCamDown		= {'S'};
	int keyCamLeft		= {'A'};
	int keyCamRight		= {'D'};

	if (gIwakee.haveOne)
		return;

	if( GetAsyncKeyState(keyUp) )
		*accel += 1;
	if( GetAsyncKeyState(keyDown) )
	{
		handBreak (true);
	}
	else
	{
		handBreak (false);
	}

// GOOD CODE:
//	camera.getMatrix().getOrigin() += camera.getMatrix().getAxisZ() * accel;

	static float l_turny = 0.0f;
	if( GetAsyncKeyState(keyCamLeft) )
		l_turny -= PI/360;
	if( GetAsyncKeyState(keyCamRight) )
		l_turny += PI/360;
	
	static float l_turnx = 0.0f;
	if( GetAsyncKeyState(keyCamUp) )
		l_turnx -= PI/360;
	if( GetAsyncKeyState(keyCamDown) )
		l_turnx += PI/360;
	
	if( GetAsyncKeyState(keyLeft) )
		*nturn += 0.5;
	if( GetAsyncKeyState(keyRight) )
		*nturn -= 0.5;

	*turnx = l_turnx;
	*turny = l_turny;
}




void CMyGame::handBreak(bool on)
{
	if (on)
	{
		for( int i = 0; i < CVehicleClass::MAX_WHEELS; ++i )
		{
			mMiniMe->mHinges[i]->setMotor2Velocity( 0 );
			mMiniMe->mHinges[i]->setMotor2MaxForce( 50000.0f );
		}
	}
	else
	{
		for( int i = 0; i < CVehicleClass::MAX_WHEELS; ++i )
		{
			mMiniMe->mHinges[i]->setMotor2Velocity( 0 );
			mMiniMe->mHinges[i]->setMotor2MaxForce( i>=2?500:1000 );
		}
	}
}




// OBSOLETE CODE:




/*		runVector.normalize ();
		mVehVector.normalize ();
		mRunToVector.normalize();

		float angle1 = acosf (runVector.dot (mVehVector));
		float angle2 = acosf (mVehVector.dot (mRunToVector));

		dingus::CConsole::getChannel( "angle1" ) << angle1/PI*180 << dingus::endl;
		dingus::CConsole::getChannel( "angle2" ) << angle2/PI*180 << dingus::endl;

		float angle = angle1 * vvweight + angle2 * rtvweight;
		dingus::CConsole::getChannel( "angle" ) << angle/PI*180 << dingus::endl;


		mVehicle->control(sqrt(rtvlen / irvlen * 5), angle/(2*PI));
*/










//		float  cosangle = sgn(mVehVector.x - runVector.x) * runVector.x * mVehVector.x + runVector.y * mVehVector.y;


/*		if (runVector.length () > 20.0f)
		{
				runVector.normalize ();
				float temp = runVector.z*3;
				runVector.z = runVector.x*3;
				runVector.x = temp;
		}
		else
		{
				runVector.normalize ();
		}

		mVehicle->getBody ().getPhysComp ().getPhysicsable ().addForce (runVector * 10000);
*/







/*	for( int i = 0; i < VEHICLES; ++i ) {
		if( mVehicle->isOutOfBounds() ) {
			mVehicle->detach();
			mVehicle->setOutOfBounds( false );
			mVehicle->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "start2" : "start1");
			mVehicle->getMatrix().getOrigin().y += 1.0f;
			mVehicle->attach();
			++mScore[VEHICLES-i-1];
			continue;
		}
		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp) )
			accel += 1;
		if( GetAsyncKeyState(keyDown) )
			accel -= 1;

		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft) )
			turn += 1;
		if( GetAsyncKeyState(keyRight) )
			turn -= 1;

		mVehicle->control( accel, turn );
	}
/**/	
