#ifndef __MY_GAME_H
#define __MY_GAME_H

#include <dingus/utils/Singleton.h>
#include <jam/BaseGame.h>
#include <jam/utils/FollowCameraController.h>
#include <jam/entity/Vehicle.h>


static const int			gNumNames = 9;
class CThingEntity;

class CShiknosEntity : public CBasePhysicsEntity {
public:
	CShiknosEntity (const std::string& name, const CEntityClass& clazz, unco::CVisibilityComponent& visComp, float mass);
	bool onLevelBound();

protected:
	void internalUpdate();
private:

};



class CMyGame : public CBaseGame, public dingus::CSingleton<CMyGame> {
public:
	virtual void onInitialize();
	virtual void onUpdate();
	virtual void onBeginCycle();
	virtual void onEndCycle();

private:
	void	createLevel( const std::string& name );
	void	performIwak ();
	void	collectInput (float *accel, float *nturn, float *turnx, float *turny);
	void	moveHero (float accel, float nturn, float turnx, float turny);
	void	checkBounds ();
	
private:
	CMyGame();
	~CMyGame();
	static CMyGame* createInstance() { return new CMyGame(); }
	static void deleteInstance( CMyGame& l ) { delete &l; }
	friend class dingus::CSingleton<CMyGame>;
	void handBreak (bool on);

private:
	CFollowCameraController		*mFollowCamera;
	//CVehicle					*mVehicle;
	CVehicle					*mMiniMe;
	CShiknosEntity				*mShikna;
	CShiknosEntity				*mSphere;
	int							mScore;
	CTextRenderer::CRenderedText	*mScoreText;
	CTextRenderer::CRenderedText	*mRenderedNames[gNumNames];
//	CBasePhysicsEntity				mShikna;
};


#endif
