#include "stdafx.h"
#pragma hdrstop

#include "CommonCollisionListener.h"
#include "entity/CollideClasses.h"
#include "entity/ThingEntity.h"
#include "entity/StaticEntity.h"
#include <unco/kernel/Contexts.h>
#include <dingus/physics-ode/PhysicsContext.h>
#include "entity/MissileEntity.h"

#include "entity/ContactEntity.h"
#include "level/Level.h"
#include "level/GameInfo.h"


void CCommonCollisionListener::onCollide( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getID() != him.getID() );

	unsigned long meCat = me.getCategoryBits();
	if( meCat & (1<<COL_ENTITY_STATIC) ) {
		collideStatic( me, him );
	} else if( meCat & (1<<COL_ENTITY_THING) ) {
		collideThing( me, him );
	} else if( meCat & (1<<COL_ENTITY_MISSILE) ) {
		collideMissile( me, him );
	}
}


void CCommonCollisionListener::collideStatic( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_STATIC) );

	unsigned long himCat = him.getCategoryBits();
	if( himCat & (1<<COL_ENTITY_THING) ) {
		collideStatic2Thing( me, him );
	} else if( himCat & (1<<COL_ENTITY_MISSILE) ) {
		collideStatic2Missile( me, him );
	}
}

void CCommonCollisionListener::collideThing( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_THING) );

	unsigned long himCat = him.getCategoryBits();
	if( himCat & (1<<COL_ENTITY_THING) ) {
		collideThing2Thing( me, him );
	} else if( himCat & (1<<COL_ENTITY_STATIC) ) {
		collideStatic2Thing( him, me );
	} else if( himCat & (1<<COL_ENTITY_MISSILE) ) {
		collideThing2Missile( me, him );
	}
}

void CCommonCollisionListener::collideMissile( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_MISSILE) );

	unsigned long himCat = him.getCategoryBits();
	if( himCat & (1<<COL_ENTITY_THING) ) {
		collideThing2Missile( him, me );
	} else if( himCat & (1<<COL_ENTITY_STATIC) ) {
		collideStatic2Missile( him, me );
	//} else if( himCat & (1<<COL_ENTITY_MISSILE) ) {
	//	collideMissile2Missile( me, him );
	}
}

int CCommonCollisionListener::commonCollide(
		dingus::CCollidable& me, dingus::CCollidable& him,
		int maxContacts, dContactGeom* contacts, dContact& c, bool isPhysMe, bool isPhysHim )
{
	int ncontacts = me.collideWith( him, maxContacts, contacts );
	if( !ncontacts )
		return ncontacts;

	dingus::TPhysicsableID physMe, physHim;
	if( isPhysMe ) {
		CBasePhysicsEntity* e = reinterpret_cast<CBasePhysicsEntity*>( me.getUserData() );
		assert( e );
		physMe = e->getPhysComp().getPhysicsable();
	} else
		physMe = NULL;
	if( isPhysHim ) {
		CBasePhysicsEntity* e = reinterpret_cast<CBasePhysicsEntity*>( him.getUserData() );
		assert( e );
		physHim = e->getPhysComp().getPhysicsable();
	} else
		physHim = NULL;

	dingus::CPhysicsContext& phys = unco::CContexts::getPhysicsCtx();
	for( int i = 0; i < ncontacts; ++i ) {
		c.geom = contacts[i];
		phys.addContactJoint( c, physMe, physHim );
		/*
		CContactEntity* ce = new CContactEntity( c.geom, CGameInfo::getInstance().getLevel().getVisStuff() );
		CGameInfo::getInstance().getLevel().getStuff().addEntity( ce );
		ce->attach();
		float scale = 0.5f + c.geom.depth * 15.0f;
		ce->getMatrix().getAxisX() *= scale;
		ce->getMatrix().getAxisY() *= scale;
		ce->getMatrix().getAxisZ() *= scale;
		*/
	}
	return ncontacts;
}


void CCommonCollisionListener::collideThing2Thing( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_THING) );
	assert( him.getCategoryBits() & (1<<COL_ENTITY_THING) );

	const int MAX_CONTACTS = 3;
	dContactGeom contacts[MAX_CONTACTS];
	dContact c;
	c.surface.mode = dContactBounce;
	c.surface.bounce = 0.5f;
	c.surface.bounce_vel = -0.5f;
	c.surface.mu = dInfinity;
	int ncontacts = commonCollide( me, him, MAX_CONTACTS, contacts, c, true, true );
}

void CCommonCollisionListener::collideThing2Missile( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_THING) );
	assert( him.getCategoryBits() & (1<<COL_ENTITY_MISSILE) );

	const int MAX_CONTACTS = 4;
	dContactGeom contacts[MAX_CONTACTS];
	dContact c;
	c.surface.mode = 0;
	c.surface.mu = dInfinity;
	int ncontacts = commonCollide( me, him, MAX_CONTACTS, contacts, c, true, true );
}

/*
void CCommonCollisionListener::collideMissile2Missile( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_MISSILE) );
	assert( him.getCategoryBits() & (1<<COL_ENTITY_MISSILE) );

	const int MAX_CONTACTS = 6;
	dContactGeom contacts[MAX_CONTACTS];
	dContact c;
	c.surface.mode = 0;
	c.surface.mu = 250;
	int ncontacts = commonCollide( me, him, MAX_CONTACTS, contacts, c, true, true );
}
*/

void CCommonCollisionListener::collideStatic2Thing( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_STATIC) );
	assert( him.getCategoryBits() & (1<<COL_ENTITY_THING) );
	CBasePhysicsEntity* e = reinterpret_cast<CBasePhysicsEntity*>( him.getUserData() );
	assert( e );
	dingus::CPhysicsable& physHim = e->getPhysComp().getPhysicsable();
	if( !physHim.isEnabled() )
		return;

	const int MAX_CONTACTS = 6;
	dContactGeom contacts[MAX_CONTACTS];
	dContact c;
	c.surface.mode = dContactBounce;
	c.surface.mu = 50;
	c.surface.bounce = 0.3f;
	c.surface.bounce_vel = 0.0f;
	//c.surface.soft_cfm = 0.00001;
	int ncontacts = commonCollide( me, him, MAX_CONTACTS, contacts, c, false, true );
}

void CCommonCollisionListener::collideStatic2Missile( dingus::CCollidable& me, dingus::CCollidable& him )
{
	assert( me.getCategoryBits() & (1<<COL_ENTITY_STATIC) );
	assert( him.getCategoryBits() & (1<<COL_ENTITY_MISSILE) );
	// HACK - so that missiles don't explode on explosions (which are statics...)
	// erm - no other static geometry should contain sphere bounds :)
	if( me.getClass() == dingus::CCollidable::COL_SPHERE )
		return;

	const int MAX_CONTACTS = 4;
	dContactGeom contacts[MAX_CONTACTS];
	int ncontacts = me.collideWith( him, MAX_CONTACTS, contacts );
	if( !ncontacts )
		return;

	CMissileEntity* e = reinterpret_cast<CMissileEntity*>( him.getUserData() );
	e->explode();
}
