#ifndef __COMMON_COLLISION_LISTENER_H
#define __COMMON_COLLISION_LISTENER_H

#include <dingus/collider-ode/CollisionListener.h>


class CCommonCollisionListener : public dingus::ICollisionListener {
public:
	virtual void onCollide( dingus::CCollidable& me, dingus::CCollidable& him );

private:
	/** Handles static-X collisions. */
	static void collideStatic( dingus::CCollidable& me, dingus::CCollidable& him );
	/** Handles thing-X collisions. */
	static void collideThing( dingus::CCollidable& me, dingus::CCollidable& him );
	/** Handles missile-X collisions. */
	static void collideMissile( dingus::CCollidable& me, dingus::CCollidable& him );

private:
	static void collideStatic2Thing( dingus::CCollidable& me, dingus::CCollidable& him );
	static void collideStatic2Missile( dingus::CCollidable& me, dingus::CCollidable& him );
	static void collideThing2Thing( dingus::CCollidable& me, dingus::CCollidable& him );
	static void collideThing2Missile( dingus::CCollidable& me, dingus::CCollidable& him );
	//static void collideCar2Car( dingus::CCollidable& me, dingus::CCollidable& him );

private:
	static int commonCollide( dingus::CCollidable& me, dingus::CCollidable& him,
		int maxContacts, dContactGeom* contacts, dContact& c, bool isPhysMe, bool isPhysHim );
};

#endif
