#ifndef __BALL_ENTITY_H
#define __BALL_ENTITY_H

#include "ThingEntity.h"

class CBallEntity : public CThingEntity {
public:
	CBallEntity( const std::string& name, const CEntityClass& clazz, int colBits, unco::CVisibilityComponent& visComp, float mass )
		: CThingEntity( name, clazz, colBits, visComp, mass ), mShouldDie(false) { ++mBallCount; }
	~CBallEntity() { --mBallCount; }

	void die() { mShouldDie = true; }

	virtual void internalUpdate() {
		if( mShouldDie ) {
			detach();
			discard();
		}
	}


public:
	static int mBallCount;

private:
	bool	mShouldDie;
};


#endif
