#include "../stdafx.h"
#pragma hdrstop

#include "EntityClasses.h"
#include "../Resources.h"

#include <dingus/resource/LuaWrapperBundle.h>
#include <dingus/lua/LuaWrapper.h>
#include <dingus/lua/LuaValue.h>
#include <dingus/lua/LuaHelper.h>
#include <dingus/lua/LuaIterator.h>
#include <dingus/resource/CollisionMeshBundle.h>

using dingus::CLuaValue;
using dingus::CLuaWrapper;
using dingus::CLuaHelper;
using dingus::CLuaArrayIterator;
	

CEntityClasses::CEntityClasses()
{
	CLuaWrapper& lua = *dingus::CLuaWrapperBundle::getInstance().getResourceById(R_LUAID_LEVEL);
	lua.doFile( R_SCRIPT_TAGS );
	lua.doFile( R_SCRIPT_MESHES );
	lua.doFile( R_SCRIPT_COLLIDERS );
	lua.doFile( R_SCRIPT_CARS );
	readStaticEntityParts();
	readThingEntityParts();
	readStaticEntityTags();
	readColliders();
}


CEntityClasses::~CEntityClasses()
{
	dingus::stl_utils::wipe_map( mThingEntityClasses );
	dingus::stl_utils::wipe_map( mStaticEntityClasses );
}


CStaticEntityClass const* CEntityClasses::getStaticEntityClass( const std::string& name ) const
{
	TStaticEntityClassMap::const_iterator it = mStaticEntityClasses.find( name );
	return (it == mStaticEntityClasses.end()) ? 0 : it->second;
}
CStaticEntityClass* CEntityClasses::getStaticEntityClass( const std::string& name )
{
	TStaticEntityClassMap::iterator it = mStaticEntityClasses.find( name );
	return (it == mStaticEntityClasses.end()) ? 0 : it->second;
}

CEntityClass const* CEntityClasses::getThingEntityClass( const std::string& name ) const
{
	TEntityClassMap::const_iterator it = mThingEntityClasses.find( name );
	return (it == mThingEntityClasses.end()) ? 0 : it->second;
}
CEntityClass* CEntityClasses::getThingEntityClass( const std::string& name )
{
	TEntityClassMap::iterator it = mThingEntityClasses.find( name );
	return (it == mThingEntityClasses.end()) ? 0 : it->second;
}

void CEntityClasses::readStaticEntityTags()
{
	CLuaWrapper& lua = *dingus::CLuaWrapperBundle::getInstance().getResourceById(R_LUAID_LEVEL);
	CLuaValue tags = lua.getGlobal( "tags" );
	CLuaArrayIterator itTags( tags );
	while( itTags.hasNext() ) {
		CLuaValue& tag = itTags.next();
		// read info
		std::string tagName = CLuaHelper::getString(tag,"name");
		std::string tagTag = CLuaHelper::getString(tag,"tag");
		SVector3 pos = CLuaHelper::getVector3(tag,"pos");
		SQuaternion rot = CLuaHelper::getQuaternion(tag,"rot");

		//
		// construct tag

		// add or fetch clazz
		TStaticEntityClassMap::iterator it = mStaticEntityClasses.find(tagName);
		if( it == mStaticEntityClasses.end() ) {
			it = mStaticEntityClasses.insert( std::make_pair( tagName, new CStaticEntityClass(tagName) ) ).first;
		}
		// add tag
		CStaticEntityClass& clazz = *it->second;
		CTag tagg( tagTag );
		tagg.setMatrix( SMatrix4x4( pos, rot ) );
		clazz.addTag( tagg );
	}
	tags.discard();
}

void CEntityClasses::readMeshParts( dingus::CLuaValue& luaParts, CEntityClass& clazz )
{
	CLuaArrayIterator itParts( luaParts );
	while( itParts.hasNext() ) {
		CLuaValue& luaPart = itParts.next();
		
		// texture, fx, layer
		std::string partTexture = CLuaHelper::getString(luaPart,"texture");
		std::string partFx = CLuaHelper::getString(luaPart,"fx");
		int partLayer = CLuaHelper::getNumber(luaPart,"layer");

		// construct and add part
		SMeshPart part;
		part.textureID = partTexture;
		part.fxID = partFx;
		part.renderLayer = partLayer;
		clazz.addPart( part );
	}
}


void CEntityClasses::readStaticEntityParts()
{
	CLuaWrapper& lua = *dingus::CLuaWrapperBundle::getInstance().getResourceById(R_LUAID_LEVEL);
	CLuaValue luaMeshes = lua.getGlobal( "staticMeshes" );
	CLuaArrayIterator itMeshes( luaMeshes );
	while( itMeshes.hasNext() ) {
		CLuaValue& luaMesh = itMeshes.next();

		// name
		std::string meshName = CLuaHelper::getString(luaMesh,"name");

		// add or fetch clazz

		TStaticEntityClassMap::iterator it = mStaticEntityClasses.find(meshName);
		if( it == mStaticEntityClasses.end() ) {
			it = mStaticEntityClasses.insert( std::make_pair( meshName, new CStaticEntityClass(meshName) ) ).first;
		}
		CStaticEntityClass& clazz = *it->second;

		// parts
		CLuaValue luaParts = luaMesh.getElement("parts");
		readMeshParts( luaParts, clazz );
		luaParts.discard();
	}
	luaMeshes.discard();
}

void CEntityClasses::readThingEntityParts()
{
	CLuaWrapper& lua = *dingus::CLuaWrapperBundle::getInstance().getResourceById(R_LUAID_LEVEL);
	CLuaValue luaMeshes = lua.getGlobal( "thingMeshes" );
	CLuaArrayIterator itMeshes( luaMeshes );
	while( itMeshes.hasNext() ) {
		CLuaValue& luaMesh = itMeshes.next();

		// name
		std::string meshName = CLuaHelper::getString(luaMesh,"name");

		// add or fetch clazz

		TEntityClassMap::iterator it = mThingEntityClasses.find(meshName);
		if( it == mThingEntityClasses.end() ) {
			it = mThingEntityClasses.insert( std::make_pair( meshName, new CEntityClass(meshName) ) ).first;
		}
		CEntityClass& clazz = *it->second;

		// parts
		CLuaValue luaParts = luaMesh.getElement("parts");
		readMeshParts( luaParts, clazz );
		luaParts.discard();
	}
	luaMeshes.discard();
}

void CEntityClasses::readColliders()
{
	CLuaWrapper& lua = *dingus::CLuaWrapperBundle::getInstance().getResourceById(R_LUAID_LEVEL);
	CLuaValue luaCols = lua.getGlobal( "colliders" );
	CLuaArrayIterator itCols( luaCols );
	while( itCols.hasNext() ) {
		CLuaValue& luaCol = itCols.next();
		std::string colName = CLuaHelper::getString(luaCol,"name");
		CEntityClass* clazz = getThingEntityClass( colName );
		if( clazz == NULL )
			clazz = getStaticEntityClass( colName );
		if( clazz == NULL )
			continue;
		readColParts( luaCol, *clazz );
	}
	luaCols.discard();
}

void CEntityClasses::readColParts( dingus::CLuaValue& luaCol, CEntityClass& clazz )
{
	CLuaValue luaSubcols = luaCol.getElement("cols");
	CLuaArrayIterator itSubcols( luaSubcols );
	while( itSubcols.hasNext() ) {
		CLuaValue& luaSubcol = itSubcols.next();

		// pos, rot
		SVector3 pos = CLuaHelper::getVector3(luaSubcol,"pos");
		SQuaternion rot = CLuaHelper::getQuaternion(luaSubcol,"rot");

		// type
		std::string colType = CLuaHelper::getString(luaSubcol,"clazz");
		if( colType == "box" ) {
			SVector3 size = CLuaHelper::getVector3(luaSubcol,"size");
			clazz.addColPart( *new CBoxCollidePartDesc(size, pos, rot) );
		} else if( colType == "mesh" ) {
			std::string name = CLuaHelper::getString(luaSubcol,"name");
			clazz.addColPart(
				*new CMeshCollidePartDesc( *dingus::CCollisionMeshBundle::getInstance().getResourceById(name+".x"), pos, rot)
				);
		} else if( colType == "sphere" ) {
			double luaRadius = CLuaHelper::getNumber(luaSubcol,"radius");
			clazz.addColPart( *new CSphereCollidePartDesc(luaRadius, pos) );
		}
	}
	luaSubcols.discard();
	clazz.calcMass();
}
