#ifndef __ENTITY_CLASSES_H
#define __ENTITY_CLASSES_H

#include "EntityClass.h"
#include "StaticEntityClass.h"


namespace dingus {
	class CLuaValue;
	class CLuaWrapper;
};


class CEntityClasses {
public:
	typedef std::map<std::string,CStaticEntityClass*>	TStaticEntityClassMap;
	typedef std::map<std::string,CEntityClass*>			TEntityClassMap;

public:
	CEntityClasses();
	~CEntityClasses();

	CStaticEntityClass const* getStaticEntityClass( const std::string& name ) const;
	TStaticEntityClassMap const& getStaticEntityClasses() const { return mStaticEntityClasses; }

	CEntityClass const* getThingEntityClass( const std::string& name ) const;
	TEntityClassMap const& getThingEntityClasses() const { return mThingEntityClasses; }

private:
	CStaticEntityClass* getStaticEntityClass( const std::string& name );
	CEntityClass* getThingEntityClass( const std::string& name );
	
	void	readStaticEntityTags();
	void	readStaticEntityParts();
	void	readThingEntityParts();
	void	readColliders();

	static void readMeshParts( dingus::CLuaValue& luaParts, CEntityClass& clazz );
	static void readColParts( dingus::CLuaValue& luaCol, CEntityClass& clazz );

private:
	TStaticEntityClassMap	mStaticEntityClasses;
	TEntityClassMap			mThingEntityClasses;
};


#endif
