#ifndef __EXPLOSION_ENTITY_H
#define __EXPLOSION_ENTITY_H

#include <unco/component/gfx/ParticlesComponent.h>
#include <dingus/gfx/particles/Particle.h>
#include <dingus/gfx/particles/ParticlePhysics.h>
#include <dingus/gfx/particles/ParticlePhysicses.h>


class CExplosionEntity : public unco::CNamedEntity {
public:
	CExplosionEntity( const std::string& name, const dingus::SVector3& pos, unco::CVisibilityComponent& visComp );
	virtual ~CExplosionEntity();

	const unco::CMeshComponent& getMesh() const { return *mMesh; }
	unco::CMeshComponent& getMesh() { return *mMesh; }
	
	void setColor( const D3DXCOLOR& color ) { mColor = color; }

protected:
	virtual void internalUpdate();

private:
	void	createMeshes();

	typedef dingus::CSizedRotColoredParticle		TParticle;
	typedef unco::CParticlesComponent<TParticle>	TParticleComp;
	typedef dingus::CVBSizedRotColoredParticleRenderer<TParticle> TParticleRenderer;
	//typedef dingus::CParticleCompositePhysics<TParticle>	TPPComposite;
	typedef dingus::CParticleAnimPhysics<TParticle>			TPPAnim;
	//typedef dingus::CParticleRepulsionPhysics<TParticle>	TPPRepulsion;

private:
	unco::CColSphereComponent*		mColSphere;
	unco::CMeshComponent*			mMesh;
	
	TParticleComp*		mParticles;
	TParticleRenderer*	mRenderer;
	//TPPComposite*		mPPComposite;
	TPPAnim*			mPPAnim;
	//TPPRepulsion*		mPPRepulsion;
	dingus::SMatrix4x4	mIdentity;

	D3DXCOLOR						mColor;
	unco::CVisibilityComponent*		mVisComp;
	int			mCounter;
};


#endif
