#ifndef __MISSILE_ENTITY_H
#define __MISSILE_ENTITY_H

#include "BasePhysicsEntity.h"
#include "CollideClasses.h"
#include "ExplosionEntity.h"
#include "../level/GameInfo.h"
#include "../level/Level.h"


class CMissileEntity : public CBasePhysicsEntity {
public:
	CMissileEntity( const std::string& name, const CEntityClass& clazz,
		int colBits, unco::CVisibilityComponent& visComp, float mass, float power, int owner )
		: CBasePhysicsEntity( name, clazz, 1<<COL_ENTITY_MISSILE, colBits, false, visComp, mass ),
		mPower(power), mOwner(owner), mShouldExplode(false) { }

	float	getPower() const { return mPower; }
	int		getOwner() const { return mOwner; }

	void	explode() { mShouldExplode = true; }

protected:
	virtual void internalUpdate() {
		if( mShouldExplode ) {
			detach();
			discard();
			CLevel& level = CGameInfo::getInstance().getLevel();
			level.getBounds().removeBoundable( getWorldMatrix() );
			CExplosionEntity* e = new CExplosionEntity( "foo!", getMatrix().getOrigin(), level.getVisStuff() );
			level.getStuff().addEntity( e );
			e->attach();
		}
	}

private:
	float	mPower;
	int		mOwner;
	bool	mShouldExplode;
};


#endif
