#include "../stdafx.h"
#pragma hdrstop

#include "SmallExplosionEntity.h"
#include <dingus/resource/TextureBundle.h>
#include <dingus/resource/IndexBufferBundle.h>


CSmallExplosionEntity::CSmallExplosionEntity( const std::string& name, const dingus::SVector3& pos,
		unco::CVisibilityComponent& visComp )
:	CNamedEntity(name),
	mVisComp( &visComp ),
	mCounter(0)
{
	mIdentity.identify();

	getMatrix().getOrigin() = pos;

	mPPAnim = new TPPAnim();
	mPPAnim->addKey( TParticle::SState(0x80C0FFFF,0.7f,0.0f) );
	mPPAnim->addKey( TParticle::SState(0xFFA0FFFF,1.0f,3.0f) );
	mPPAnim->addKey( TParticle::SState(0x4080A0FF,0.5f,1.0f) );
	mRenderer = new TParticleRenderer();
	mParticles = new TParticleComp( *mPPAnim, *mRenderer,
		*dingus::CIndexBufferBundle::getInstance().getResourceById("ibQuads"),
		"particleColor.fx", 2, mIdentity
	);
	mParticles->getParams().addTexture( "tBase",
		*dingus::CTextureBundle::getInstance().getResourceById("spark.png")
		);
	addComponent( *mParticles );
	mVisComp->addListener( *mParticles );
}

CSmallExplosionEntity::~CSmallExplosionEntity()
{
	mVisComp->removeListener( *mParticles );
}


void CSmallExplosionEntity::internalUpdate()
{
	int lifetime = 100;
	float alpha = (float)mCounter / lifetime;
	float size = alpha<0.3f ? (alpha/0.3)*0.6f : (1-alpha)/0.7f*0.6f;

	dingus::SVector3 pos = getMatrix().getOrigin();
	pos.x += dingus::random( -0.2f, 0.2f );
	pos.y += dingus::random( 0.4f );
	pos.z += dingus::random( -0.2f, 0.2f );
	dingus::SVector3 vel;
	vel.x = dingus::random(-2.4f,2.4f);
	vel.y = dingus::random(-2.4f,2.4f);
	vel.z = dingus::random(-2.4f,2.4f);
	mParticles->getParticleSystem().addParticle(
		TParticle( pos, vel, 0xFFFFFFFF, 1.2f*size, 0.0f, 1.0f )
	);

	++mCounter;
	if( mCounter > lifetime ) {
		detach();
		discard();
	}
}
