#ifndef __S_EXPLOSION_ENTITY_H
#define __S_EXPLOSION_ENTITY_H

#include <unco/component/gfx/ParticlesComponent.h>
#include <dingus/gfx/particles/Particle.h>
#include <dingus/gfx/particles/ParticlePhysics.h>
#include <dingus/gfx/particles/ParticlePhysicses.h>


class CSmallExplosionEntity : public unco::CNamedEntity {
public:
	CSmallExplosionEntity( const std::string& name, const dingus::SVector3& pos, unco::CVisibilityComponent& visComp );
	virtual ~CSmallExplosionEntity();

protected:
	virtual void internalUpdate();

private:
	typedef dingus::CSizedRotColoredParticle		TParticle;
	typedef unco::CParticlesComponent<TParticle>	TParticleComp;
	typedef dingus::CVBSizedRotColoredParticleRenderer<TParticle> TParticleRenderer;
	typedef dingus::CParticleAnimPhysics<TParticle>			TPPAnim;

private:
	TParticleComp*		mParticles;
	TParticleRenderer*	mRenderer;
	TPPAnim*			mPPAnim;
	dingus::SMatrix4x4	mIdentity;

	unco::CVisibilityComponent*		mVisComp;
	int			mCounter;
};


#endif
