#include "../stdafx.h"
#pragma hdrstop

#include "LevelBounds.h"

const float CLevelBounds::BOUND_DIST = 100.0f;

void CLevelBounds::update()
{
	TBoundableMap::iterator it, itEnd = mBoundables.end();
	for( it = mBoundables.begin(); it != itEnd; /**/ ) {
		const dingus::SMatrix4x4& m = *it->first;
		if( !mAABB.isInside( m.getOrigin() ) ) {
			if( it->second ) {
				bool rem = it->second->onLevelBound();
				if( rem ) {
					it = mBoundables.erase(it);
					itEnd = mBoundables.end();
					continue;
				}
			}
		}
		++it;
	}
}
