#include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <dingus/kernel/SystemClock.h>
#include <jam/entity/MissileEntity.h>
#include <jam/entity/BallEntity.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <jam/entity/SmallExplosionEntity.h>
#include <dingus/resource/TextureBundle.h>

// HACK
int CBallEntity::mBallCount = 0;


CMyGame::CMyGame()
{
	/*
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 7.0f, 2.0f, 4.0f );
	}*/
}
CMyGame::~CMyGame()
{
}



void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;

		char buf1[100], buf2[100];
		sprintf( buf1, "line%i1", i+1 );
		sprintf( buf2, "line%i2", i+1 );
		const SMatrix4x4& gate1m = level.getMarkers().getValue(buf1);
		const SMatrix4x4& gate2m = level.getMarkers().getValue(buf2);
		SVector3 boxlen( SVector3(gate1m.getOrigin()-gate2m.getOrigin()).length()*2.0f, 30.0f, 3.0f );
		mGates[i] = new CCollidableBox( NULL, boxlen );
		mGates[i]->setRotation( gate1m );
		mGates[i]->setPosition( (gate1m.getOrigin()+gate2m.getOrigin())*0.5f );
		mGates[i]->addListener( *this );
		mGates[i]->setCategoryBits( 1<<COL_UI_TAGS );
		mGates[i]->setCollideBits( (1<<COL_ENTITY_THING) );
		CContexts::getCollisionCtx().addCollidable( *mGates[i] );

		mViewX[i] = 0.0f;
		mViewY[i] = 0.0f;

		mBillCross[i] = &getBillboards().addBill( *CTextureBundle::getInstance().getResourceById("cross.png") );
		mBillCross[i]->setWholeTexture();
		mBillCross[i]->x1 = -0.05f;
		mBillCross[i]->x2 =  0.05f;
		mBillCross[i]->y1 = i-0.56f;
		mBillCross[i]->y2 = i-0.44f;
		mBillCross[i]->color = 0xFFFFFFFF;

		mLastMissile[i] = CSystemClock::getInstance().getTime();
	}
	mLastTime = CSystemClock::getInstance().getTime();
	mCounter = 0;
	mGodX = mGodY = 0.0f;
}

void CMyGame::onInitialize()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mScore[i] = 0;
	}
	createLevel( "../data/script/levels/fight01.lua" );
}

void CMyGame::onBeginCycle()
{
	std::string txtInfo[VEHICLES] = { "Arrows/Ctrl", "WSAD/Space" };
	for( int i = 0; i < VEHICLES; ++i ) {
		char buf[100];
		sprintf( buf, "score: %i", mScore[i] );
		float height = 0.06f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, 0xFFFFFFFF
		);
		mInfoText[i] = getTextRenderer().renderTextHeight( txtInfo[i],
			SVector2(-0.95f,i-height), height, 0xFFC0C0C0
		);
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
		delete mInfoText[i];
	}
}

void CMyGame::onCollide( CCollidable& me, CCollidable& him )
{
	CCollidable *gate = NULL;
	CCollidable *th = NULL;
	if( me.getCategoryBits() & (1<<COL_UI_TAGS) ) {
		gate = &me;
		th = &him;
	} else if( him.getCategoryBits() & (1<<COL_UI_TAGS) ) {
		gate = &him;
		th = &me;
	}
	assert( gate );
	assert( th );

	CSmallExplosionEntity* e = new CSmallExplosionEntity( "boo!", th->getPosition(), CGameInfo::getInstance().getLevel().getVisStuff() );
	CGameInfo::getInstance().getLevel().getStuff().addEntity( e );
	e->attach();

	CBallEntity* te = (CBallEntity*)th->getUserData();
	CGameInfo::getInstance().getLevel().getBounds().removeBoundable( te->getWorldMatrix() );
	te->die();

	if( gate == mGates[0] )
		++mScore[1];
	else
		++mScore[0];
}


void CMyGame::onUpdate()
{
	double t = CSystemClock::getInstance().getTime();
	mGodX = sinf(t + cosf(t*0.55f))*20.0f;
	mGodY = cosf(t + sinf(t*0.43f))*40.0f;

	if( t-mLastTime > 0.3f && CBallEntity::mBallCount < 100 ) {
		char buf[100];
		sprintf( buf, "sh%i", mCounter++ );
		CLevel& l = CGameInfo::getInstance().getLevel();
		SMatrix4x4 m = l.getMarkers().getValue("center");
		m.getOrigin().y += 30.0f;
		m.getOrigin().x += (rand()%1000-500) * 0.01f + mGodX;
		m.getOrigin().z += (rand()%1000-500) * 0.01f + mGodY;
		const char* clazzes[] = { "Sphere", "Brick", "Barrel" };
		CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass(
			clazzes[0]
			);
		assert( clazz );
		const float THING_MASS = 20.0f;
		CBallEntity* e = new CBallEntity( buf, *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), l.getVisThing(), THING_MASS );
		l.getThingEntities().addEntity( e );
		e->getMatrix() = m;
		e->getPhysComp().setMatrixPORed( m );
		e->attach();
		l.getBounds().addBoundable( e->getWorldMatrix(), e );
		mLastTime = t;
	}
	
	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
	int keyFire[VEHICLES] = { VK_CONTROL, ' ' };

	for( int i = 0; i < VEHICLES; ++i ) {
		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp[i]) )
			accel += 1;
		if( GetAsyncKeyState(keyDown[i]) )
			accel -= 1;

		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft[i]) )
			turn += 1;
		if( GetAsyncKeyState(keyRight[i]) )
			turn -= 1;

		const SMatrix4x4& markM = CGameInfo::getInstance().getLevel().getMarkers().getValue(i ? "start2" : "start1");
		mViewX[i] -= turn * 0.01f;
		mViewY[i] += accel * 0.01f;
		SVector3 az = markM.getAxisZ();
		az += markM.getAxisX() * mViewX[i];
		az += markM.getAxisY() * mViewY[i];
		SMatrix4x4& camm = getCamera((eView)i).getMatrix();
		SVector3 ax = SVector3(0,1,0).cross(az).getNormalized();
		SVector3 ay = az.cross(ax);
		camm.getAxisX() = ax;
		camm.getAxisY() = ay;
		camm.getAxisZ() = az;

		mViewX[i] *= 0.98f;
		mViewY[i] *= 0.98f;
		if( mViewX[i] > 1 )		mViewX[i] = 1;
		if( mViewY[i] > 1 )		mViewY[i] = 1;
		if( mViewX[i] < -1 )	mViewX[i] = -1;
		if( mViewY[i] < -1 )	mViewY[i] = -1;

		const double INTERVAL = 0.3;
		if( GetAsyncKeyState(keyFire[i]) && t-mLastMissile[i]>INTERVAL ) {
			mLastMissile[i] = t;
			CLevel& level = CGameInfo::getInstance().getLevel();
			CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( "Sphere" );
			assert( clazz );
			const float THING_MASS = 12.0f;
			char buf[100];
			sprintf( buf, "m%i", mCounter++ );
			CMissileEntity* e = new CMissileEntity( buf, *clazz, (1<<COL_ENTITY_STATIC)|((1<<COL_ENTITY_THING)), level.getVisThing(), THING_MASS,
				100.0f, i );
			e->setColor( i ? 0xFFFF6020 : 0xFF60FF20 );
			level.getThingEntities().addEntity( e );
			e->getPhysComp().setMatrixPORed( camm );
			e->attach();
			SVector3 f = camm.getAxisZ() * 50000.0f + camm.getAxisY() * 7500.0f;
			e->getPhysComp().getPhysicsable().addForce( f );
			level.getBounds().addBoundable( e->getWorldMatrix(), e );
		}
	}

	CGameInfo::getInstance().getLevel().update();
}
