#ifndef __MY_GAME_H
#define __MY_GAME_H

#include <dingus/utils/Singleton.h>
#include <jam/BaseGame.h>


class CMyGame : public CBaseGame, public dingus::CSingleton<CMyGame>, public ICollisionListener {
public:
	enum { VEHICLES = 2 };
public:
	virtual void onInitialize();
	virtual void onUpdate();
	virtual void onBeginCycle();
	virtual void onEndCycle();

	virtual void onCollide( CCollidable& me, CCollidable& him );

private:
	void	createLevel( const std::string& name );
	
private:
	CMyGame();
	~CMyGame();
	static CMyGame* createInstance() { return new CMyGame(); }
	static void deleteInstance( CMyGame& l ) { delete &l; }
	friend class dingus::CSingleton<CMyGame>;

private:
	int							mScore[VEHICLES];
	CTextRenderer::CRenderedText*	mScoreText[VEHICLES];
	CTextRenderer::CRenderedText*	mInfoText[VEHICLES];
	SBillboard*						mBillCross[VEHICLES];
	float		mViewX[VEHICLES];
	float		mViewY[VEHICLES];
	double		mLastTime;
	double		mLastMissile[VEHICLES];
	int			mCounter;
	float		mGodX, mGodY;
	dingus::CCollidableBox*		mGates[VEHICLES];
};


#endif
