#include "../stdafx.h"
#pragma hdrstop

#include "BaseEntity.h"
#include <dingus/resource/MeshBundle.h>
#include <dingus/resource/TextureBundle.h>
#include <dingus/collider-ode/Collidable.h>


CBaseEntity::CBaseEntity( const std::string& name, const CEntityClass& clazz,
		int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp )
:	CNamedEntity(name),
	mClass(&clazz),
	mCullMode(flipCull?D3DCULL_CW:D3DCULL_CCW),
	mColor(0x50808080),
	mVisComp( &visComp ),
	mExternalColContainer(false)
{
	createMeshes();
	mColContainer = &clazz.createColComponents( *this, catBits, colBits, flipCull );
}

CBaseEntity::CBaseEntity( const std::string& name, const CEntityClass& clazz,
		int catBits, int colBits, bool flipCull, unco::CVisibilityComponent& visComp,
		dingus::CCollidableContainer& colContainer )
:	CNamedEntity(name),
	mClass(&clazz),
	mColContainer(&colContainer),
	mCullMode(flipCull?D3DCULL_CW:D3DCULL_CCW),
	mColor(0x50808080),
	mVisComp( &visComp ),
	mExternalColContainer(true)
{
	createMeshes();
	clazz.createColComponents( *this, catBits, colBits, flipCull, colContainer );
}

void CBaseEntity::createMeshes()
{
	for( int p = 0; p < mClass->getParts().size(); ++p ) {
		SMeshPart const& part = mClass->getParts()[p];
		unco::CMeshComponent* mesh = new unco::CMeshComponent(
			*dingus::CMeshBundle::getInstance().getResourceById( mClass->getName() + ".x" ),
			p,
			part.fxID,
			part.renderLayer,
			getWorldMatrix()
		);
		dingus::CEffectParams& params = mesh->getParams();
		params.addTexture( "tBase", *dingus::CTextureBundle::getInstance().getResourceById( part.textureID ) );
		params.addIntRef( "dwCull", (int*)&mCullMode );
		params.addColor4Ref( "vColor", mColor );

		addComponent( *mesh );
		mVisComp->addListener( *mesh );
		mMeshes.push_back( mesh );
	}
}

CBaseEntity::~CBaseEntity()
{
	if( !mExternalColContainer )
		delete mColContainer;
	TMeshCompVector::iterator it, itEnd = mMeshes.end();
	for( it = mMeshes.begin(); it != itEnd; ++it ) {
		unco::CMeshComponent* comp = *it;
		mVisComp->removeListener( *comp );
	}
}
