#ifndef __CONTACT_ENTITY_H
#define __CONTACT_ENTITY_H

#include <unco/entity/Entity.h>
#include <dingus/resource/MeshBundle.h>


class CContactEntity : public unco::CEntity {
public:
	CContactEntity( const dContactGeom& c, unco::CVisibilityComponent& visComp )
		: mUpdateCount(0), mVisComp(&visComp)
	{
		getMatrix().getAxisY().set( c.normal[0], c.normal[1], c.normal[2] );
		getMatrix().spaceFromAxisY();
		getMatrix().getOrigin().set( c.pos[0], c.pos[1], c.pos[2] );

		mMeshComp = new unco::CMeshComponent(
			*dingus::CMeshBundle::getInstance().getResourceById("tripod.x"), 0,
			"textured.fx", 0,
			getWorldMatrix()
		);
		addComponent( *mMeshComp );
		mVisComp->addListener( *mMeshComp );
	}
	virtual ~CContactEntity()
	{
		mVisComp->removeListener( *mMeshComp );
	}

	unco::CMeshComponent& getMeshComp() { return *mMeshComp; }

protected:
	virtual void internalUpdate() {
		++mUpdateCount;
		if( mUpdateCount > 3 ) {
			detach();
			discard();
		}
	}

private:
	int						mUpdateCount;
	unco::CMeshComponent*	mMeshComp;
	unco::CVisibilityComponent*		mVisComp;
};

#endif
