#include "../stdafx.h"
#pragma hdrstop

#include "SphereEntity.h"
#include "CollideClasses.h"
#include <dingus/resource/MeshBundle.h>
#include <dingus/resource/TextureBundle.h>
#include <dingus/collider-ode/Collidable.h>
#include <dingus/resource/IndexBufferBundle.h>
#include <dingus/resource/TextureBundle.h>


using namespace dingus;

SMatrix4x4 CSphereEntity::mIdentity;
int CSphereEntity::mSphereCount = 0;


CSphereEntity::CSphereEntity( const std::string& name, const CEntityClass& clazz,
		int colBits, unco::CVisibilityComponent& visComp, float mass )
:	CBasePhysicsEntity( name, clazz, 1<<COL_ENTITY_THING, colBits, false, visComp, mass ),
	mLastTouch(NULL), mFastCount(0)
{
	++mSphereCount;
	mIdentity.identify();
	//mPPComposite = new TPPComposite();
	mPPAnim = new TPPAnim();
	mPPAnim->addKey( TParticle::SState(0x00FFFFFF,0.2f,0.0f) );
	mPPAnim->addKey( TParticle::SState(0x10FFFFFF,0.6f,1.0f) );
	mPPAnim->addKey( TParticle::SState(0x00FFFFFF,0.8f,2.0f) );
	//mPPRepulsion = new TPPRepulsion( pos, 10.0f );
	//mPPComposite->addPhysics( *mPPAnim );
	mRenderer = new TParticleRenderer();
	mParticles = new TParticleComp( *mPPAnim, *mRenderer,
		*dingus::CIndexBufferBundle::getInstance().getResourceById("ibQuads"),
		"particleColor.fx", 2, mIdentity
	);
	mParticles->getParams().addTexture( "tBase",
		*dingus::CTextureBundle::getInstance().getResourceById("smoke.png")
		);
	addComponent( *mParticles );
	getVisComp().addListener( *mParticles );
}

CSphereEntity::~CSphereEntity()
{
	--mSphereCount;
	getVisComp().removeListener( *mParticles );
}

void CSphereEntity::internalUpdate()
{
	if( !mLastTouch )
		return;
	double v = getPhysComp().getPhysicsable().getAngularVel().lengthSq();
	v *= 0.00001;

	const double MIN_VELOCITY = 0.003;
	const double SMOKE_VELOCITY = 0.028;
	const double EXPLODE_VELOCITY = 0.032;
	const int EXPLODE_COUNT = 400;

	if( v > MIN_VELOCITY )
		mLastTouch->getScore() += v * 0.2f;

	if( v > EXPLODE_VELOCITY && mFastCount > EXPLODE_COUNT ) {
		mLastTouch->getScore() += 10.0f;
		detach();
		discard();
		CLevel& level = CGameInfo::getInstance().getLevel();
		level.getBounds().removeBoundable( getWorldMatrix() );
		CExplosionEntity* e = new CExplosionEntity( "foo!", getMatrix().getOrigin(), level.getVisStuff(), 30.0f );
		level.getStuff().addEntity( e );
		e->attach();
		// TBD: new sphere
		return;
	}

	if( v > SMOKE_VELOCITY ) {
		++mFastCount;
		for( int i = 0; i < 4; ++i ) {
			dingus::SVector3 pos = getMatrix().getOrigin();
			pos.x += dingus::random( -0.3f, 0.3f );
			pos.z += dingus::random( -0.3f, 0.3f );
			dingus::SVector3 vel;
			vel.x = dingus::random(-0.6f,0.6f);
			vel.y = dingus::random(0.6f,1.6f);
			vel.z = dingus::random(-0.6f,0.6f);
			mParticles->getParticleSystem().addParticle(
				TParticle( pos, vel, 0x00FFFFFF, 2.0f, 0.0f, 2.0f )
			);
		}
	} else {
		mFastCount = 0;
	}
}
