#ifndef __SPHERE_ENTITY_H
#define __SPHERE_ENTITY_H

#include "BasePhysicsEntity.h"
#include "CollideClasses.h"
#include "ExplosionEntity.h"
#include "Vehicle.h"
#include "../level/GameInfo.h"
#include "../level/Level.h"
#include <unco/component/gfx/ParticlesComponent.h>
#include <dingus/gfx/particles/Particle.h>
#include <dingus/gfx/particles/ParticlePhysics.h>
#include <dingus/gfx/particles/ParticlePhysicses.h>


class CSphereEntity : public CBasePhysicsEntity {
public:
	CSphereEntity( const std::string& name, const CEntityClass& clazz,
		int colBits, unco::CVisibilityComponent& visComp, float mass );
	~CSphereEntity();

	void touch( CVehicle& v ) {
		mLastTouch = &v;
		setColor( v.getWheel(0).getColor() );
	}

protected:
	void internalUpdate();

	typedef dingus::CSizedRotColoredParticle		TParticle;
	typedef unco::CParticlesComponent<TParticle>	TParticleComp;
	typedef dingus::CVBSizedRotColoredParticleRenderer<TParticle> TParticleRenderer;
	//typedef dingus::CParticleCompositePhysics<TParticle>	TPPComposite;
	typedef dingus::CParticleAnimPhysics<TParticle>			TPPAnim;
	//typedef dingus::CParticleRepulsionPhysics<TParticle>	TPPRepulsion;

public:
	static int mSphereCount;
	
private:
	CVehicle*			mLastTouch;
	int					mFastCount;
	TParticleComp*		mParticles;
	TParticleRenderer*	mRenderer;
	TPPAnim*			mPPAnim;
	static dingus::SMatrix4x4	mIdentity;
};


#endif
