#ifndef __FOLLOW_CAMERA_CONTROLLER_H
#define __FOLLOW_CAMERA_CONTROLLER_H



class CFollowCameraController {
public:
	CFollowCameraController( float distance, float height, float omegaSq );

	void setFollowMatrix( const SMatrix4x4& m ) { mFollowMatrix = &m; };
	void setAffectedMatrix( SMatrix4x4& m ) { mAffectedMatrix = &m; };

	void update( float dt, const SVector3& followVelocity, bool useDir );

private:
	const SMatrix4x4* mFollowMatrix;
	SMatrix4x4*		mAffectedMatrix;
	SVector3		mVelocity;

public:
	float	mDistance;
	float	mHeight;

	float	mOmegaSq;
	float	mBeta;
};


#endif
