#include "stdafx.h"
#pragma hdrstop

#include "MyGame.h"
#include <jam/GameLevelCreator.h>
#include <jam/level/GameInfo.h>
#include <jam/level/Level.h>
#include <jam/entity/EntityClasses.h>
#include <jam/entity/Vehicle.h>
#include <jam/entity/SphereEntity.h>
#include <dingus/kernel/SystemClock.h>
#include <dingus/collider-ode/CollisionContext.h>
#include <dingus/resource/TextureBundle.h>


CMyGame::CMyGame()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i] = new CFollowCameraController( 4.5f, 1.4f, 40.0f );
	}
}
CMyGame::~CMyGame()
{
}


void CMyGame::createLevel( const std::string& name )
{
	CGameInfo::getInstance().createNewLevel();
	CLevel& level = CGameInfo::getInstance().getLevel();

	CGameLevelCreator creator;
	CLevelFileReader::read( name.c_str(), creator );

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		const SMatrix4x4& markM = level.getMarkers().getValue(i ? "start2" : "start1");
		CCamera& camera = getCamera((eView)i);
		SMatrix4x4& m = camera.getMatrix();
		m = markM;
		m.getOrigin().y += 2.0f;
		m.getOrigin() -= m.getAxisZ()*10.0f;

		// HACK - create vehicle
		SMatrix4x4 carm = markM;
		carm.getOrigin().y += 1.0f;
		const char* name = "monster";
		mVehicle[i] = new CVehicle( "test", *CGameInfo::getInstance().getClasses().getVehicleClass(name), level.getVisStuff() );
		level.getStuff().addEntity( mVehicle[i] );
		mVehicle[i]->getMatrix() = carm;
		mVehicle[i]->attach();
		level.getBounds().addBoundable( mVehicle[i]->getWorldMatrix(), mVehicle[i] );

		for( int w = 0; w < 4; ++w ) {
			mVehicle[i]->getWheel(w).setColor( i ? 0xFFFF4040 : 0xFF40FF40 );
		}

		mFollowCamera[i]->setAffectedMatrix( m );
		mFollowCamera[i]->setFollowMatrix( mVehicle[i]->getWorldMatrix() );
	}
	mCounter = 0;
}

void CMyGame::onInitialize()
{
	createLevel( "../data/script/levels/level.lua" );
}

void CMyGame::onBeginCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		char buf[100];
		sprintf( buf, "score: %.3f", mVehicle[i]->getScore()/*, CSphereEntity::mSphereCount*/ );
		float height = 0.06f;
		float width = getTextRenderer().getWidth( buf, height );
		mScoreText[i] = getTextRenderer().renderTextHeight( buf,
			SVector2(0.95f-width,i-height), height, 0xC0FFFFFF
		);
		mHelpText[i] = getTextRenderer().renderTextHeight(
			i ? "WSAD" : "Arrows",
			SVector2(-0.99f,i-height), height*0.6f, 0xA0FFFFFF );
	}
}

void CMyGame::onEndCycle()
{
	for( int i = 0; i < VEHICLES; ++i ) {
		delete mScoreText[i];
		delete mHelpText[i];
	}
}

void CMyGame::onUpdate()
{
	double t = CSystemClock::getInstance().getTime();

	const double SPHERE_TIME = 2.2;
	const int MAX_SPHERES = 30;
	if( t-mLastSphere > SPHERE_TIME && CSphereEntity::mSphereCount < MAX_SPHERES ) {
		CLevel& level = CGameInfo::getInstance().getLevel();
		CEntityClass const* clazz = CGameInfo::getInstance().getClasses().getThingEntityClass( "Sphere" );
		assert( clazz );
		const float THING_MASS = 20.0f;
		char buf[100];
		sprintf( buf, "m%i", mCounter++ );
		CSphereEntity* e = new CSphereEntity( buf, *clazz, (1<<COL_ENTITY_STATIC)|(1<<COL_ENTITY_CAR), level.getVisThing(), THING_MASS );
		//e->setColor( i ? 0xFFFF6020 : 0xFF60FF20 );
		e->getMatrix().identify();
		const SVector3& lmin = level.getBounds().getAABB().getMin();
		const SVector3& lmax = level.getBounds().getAABB().getMax();
		e->getMatrix().getOrigin().x = random( lmin.x, lmax.x );
		e->getMatrix().getOrigin().z = random( lmin.z, lmax.z );
		e->getMatrix().getOrigin().y = (lmin.y+lmax.y)/2+20.0f;
		level.getThingEntities().addEntity( e );
		e->getPhysComp().setMatrixPORed( e->getMatrix() );
		e->attach();
		level.getBounds().addBoundable( e->getWorldMatrix(), e );
		mLastSphere = t;
	}

	int keyUp[VEHICLES] = { VK_UP, 'W' };
	int keyDown[VEHICLES] = { VK_DOWN, 'S' };
	int keyLeft[VEHICLES] = { VK_LEFT, 'A' };
	int keyRight[VEHICLES] = { VK_RIGHT, 'D' };
	int keyFire[VEHICLES] = { VK_CONTROL, ' ' };
	int keyViewUp[VEHICLES] = { VK_PRIOR, 'R' };
	int keyViewDown[VEHICLES] = { VK_NEXT, 'F' };
	int keyChange[VEHICLES] = { VK_END, 'Q' };

	int i;
	for( i = 0; i < VEHICLES; ++i ) {
		float accel = 0.0f;
		if( GetAsyncKeyState(keyUp[i]) )
			accel += 1;
		if( GetAsyncKeyState(keyDown[i]) )
			accel -= 1;

		float turn = 0.0f;
		if( GetAsyncKeyState(keyLeft[i]) )
			turn += 1;
		if( GetAsyncKeyState(keyRight[i]) )
			turn -= 1;

		mVehicle[i]->control( accel, turn );
	}

	CGameInfo::getInstance().getLevel().update();

	for( i = 0; i < VEHICLES; ++i ) {
		mFollowCamera[i]->update( 1.0f/200.0f, mVehicle[i]->getBody().getPhysComp().getPhysicsable().getLinearVel()*0.7f, true );
		/*
		SMatrix4x4& m = getCamera((eView)i).getMatrix();
		m = mVehicle[i]->getBody().getMatrix();
		//m.getOrigin() -= m.getAxisZ()*0.1f;
		m.getOrigin() += m.getAxisY()*0.75f;
		m.getOrigin() -= m.getAxisX()*0.3f;
		*/
		if( mVehicle[i]->isOutOfBounds() ) {
			mVehicle[i]->detach();
			mVehicle[i]->setOutOfBounds( false );
			std::string place = "start";
			place += '1'+i;
			mVehicle[i]->getMatrix() = CGameInfo::getInstance().getLevel().getMarkers().getValue( place );
			mVehicle[i]->getMatrix().getOrigin().y += 1.0f;
			mVehicle[i]->attach();
			continue;
		}
	}
}
