// global effect as used by the framework

#include "_shared.fx"

technique tec0 {
	pass P0 {
		ViewTransform = (mView);
		ProjectionTransform = (mProjection);

		// material
        MaterialAmbient   = {1.0, 1.0, 1.0, 1.0}; 
        MaterialDiffuse   = {1.0, 1.0, 1.0, 1.0}; 
        MaterialSpecular  = {1.0, 1.0, 1.0, 1.0}; 
        MaterialPower     = 20.0;
        
        // set up one directional light
        LightType[0]      = DIRECTIONAL;
        LightAmbient[0]   = {0.3, 0.3, 0.3, 1.0};
        LightDiffuse[0]   = {0.9, 0.9, 0.9, 1.0};
        LightSpecular[0]  = {0.4, 0.4, 0.4, 1.0}; 
        LightDirection[0] = {0.5, -0.7, 0.3};
        LightRange[0]     = 100000.0f;

		LightEnable[0] = True;
        SpecularEnable = False;
		NormalizeNormals = True;

		// Texture params
		MinFilter[0] = Linear;
		MagFilter[0] = Linear;
		MipFilter[0] = Linear;
		MinFilter[1] = Linear;
		MagFilter[1] = Linear;
		MipFilter[1] = Linear;
	}
}
