function makePart( tex, mode )
	local fxs = { 'textured.fx', 'texturedAlpha.fx' }
	local layers = { 0, 1 }
	return { texture=tex, fx=fxs[mode], layer=layers[mode] }
end
function makeMesh( mesh, pts )
	return { name=mesh, parts=pts }
end
modeSimple = 1
modeAlpha = 2

partsSquare = {
	makePart( 'square01.jpg', modeSimple ),
}

staticMeshes = {
makeMesh( 'Bliudas', partsSquare ),
}

thingMeshes = {
makeMesh( 'o_marker', { makePart( 'rgb01.png', modeSimple ) } ),
makeMesh( 'Sphere', { makePart( 'rgb01.png', modeSimple ) } ),
}
