import os
import random

def _readLines(filename):
    """Read in lines from file

    Filename is relative to the module.
    Returned lines are stripped.
    """
    lines = file(filename).readlines()
    return [line.strip() for line in lines]

first_names = _readLines('data/first_names.txt')
last_names = _readLines('data/last_names.txt')


def generate():
    """Generates name information, returns tuple of
    first name, last name, full name
    """
    first_name = random.choice(first_names)
    last_name = random.choice(last_names)
    full_name = "%s %s" % (first_name, last_name)
    return full_name
