float4x4 matWorldViewProj, matWorld, matTex;

texture tex;
sampler2D texSampler 
{
	Texture	  = (tex);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
	ADDRESSU= CLAMP;
	ADDRESSV= CLAMP;
};

struct VS_OUTPUT
{
	float4 Pos : POSITION;	
	float2 tex: TEXCOORD2;
};


float4 info;
VS_OUTPUT VS(  float4 Pos	: POSITION)
{
   VS_OUTPUT OUT;
   OUT.Pos= Pos;
	OUT.Pos.xy= Pos*info.xy+ info.zw;
	OUT.tex= Pos.xy;
	return OUT;
};

float4 PS( VS_OUTPUT IN):COLOR
{
	//return float4(0,1,1,0);
	return tex2D(texSampler, IN.tex);
};


technique Simple
{
    pass Pass0
    {
		
		VertexShader = compile vs_1_1 VS();
		PixelShader  = compile ps_2_0 PS();
		//FILLMODE= WIREFRAME;
		CULLMODE= NONE;
    }  
}
