float4x4 matWorldViewProj, matWorld;


texture tex;
sampler2D texSampler 
{
	Texture	  = (tex);
    MIPFILTER = none;
    MAGFILTER = none;
    MINFILTER = none;
	ADDRESSU= CLAMP;
	ADDRESSV= CLAMP;
};

struct VS_OUTPUT
{
	float4 Pos		: POSITION;
	float light: TEXCOORD0;
	float2 tex: TEXCOORD1;
	
};



VS_OUTPUT VS(  float4 Pos	: POSITION, float2 tex:TEXCOORD0, float3 normal: Normal)
{
   VS_OUTPUT OUT;
	OUT.Pos= mul(Pos, matWorldViewProj );
	normal= mul(normal, (float3x3)matWorld);
	OUT.light= saturate(dot(normal, normalize(float3(1,1,1))));
	OUT.light= saturate(OUT.light+0.5);
	OUT.tex= tex;
	
	return OUT;
};

float4 PS( VS_OUTPUT IN):COLOR
{
	
	//return float4(1,0,0,0);
	float4 tex= tex2D(texSampler, IN.tex);
	return /*IN.light */ tex;
};


technique Simple
{
    pass Pass0
    {
		
		VertexShader = compile vs_1_1 VS();
		PixelShader  = compile ps_2_0 PS();
		//FILLMODE= WIREFRAME;
		//CULLMODE= CCW;
		
		SRCBLEND= DESTCOLOR;
		DESTBLEND= ZERO;
		ALPHABLENDENABLE= true;
		
    }  
}

texture texLight;
sampler2D lightSampler 
{
	Texture	  = (texLight);
    MIPFILTER = NONE;
    MAGFILTER = NONE;
    MINFILTER = NONE;
	ADDRESSU= CLAMP;
	ADDRESSV=CLAMP;
	ADDRESSW= CLAMP;
	
};

float4x4 matProjector;
float4x4 matTex= float4x4(0.5f, 0.0f, 0.0f, 0.0f,
    						0.0f, -0.5f, 0.0f,0.0f,
   	 						0.0f, 0.0f, 0.5f, 0.0f,
    						0.5f, 0.5f, 0.5f, 1.0f);
struct VS_OUTPUT_LIGHT
{
	float4 Pos	: POSITION;
	float4 tex: TEXCOORD1;
};



VS_OUTPUT_LIGHT VS_LIGHT(  float4 Pos	: POSITION )
{
   VS_OUTPUT_LIGHT OUT;
	OUT.Pos= mul(Pos, matWorldViewProj );
	
	
	OUT.tex= mul(Pos, matWorld);
	OUT.tex= mul(OUT.tex, matProjector);
	OUT.tex= mul(OUT.tex, matTex);
	
	return OUT;
};

float4 PS_LIGHT( VS_OUTPUT_LIGHT IN):COLOR
{
	
	//return float4(0,1,0,0);
	float light= tex2Dproj(lightSampler, IN.tex*5);
	return light;
	//return IN.tex.x;
};


float4 PS_AMB( VS_OUTPUT IN):COLOR
{
	
	return 0.2f;
	//return tex2D(texSampler, IN.tex);
	//return IN.tex.x;
};


technique LightFirst
{
    pass Pass0
    {
		
		VertexShader = compile vs_1_1 VS_LIGHT();
		PixelShader  = compile ps_2_0 PS_LIGHT();
		//FILLMODE= WIREFRAME;
		//CULLMODE= CCW;
		//SRCBLEND= DESTCOLOR;
		//DESTBLEND= ZERO;
		//ALPHABLENDENABLE= true;
    }  
}
technique Light
{
    pass Pass0
    {
		
		VertexShader = compile vs_1_1 VS_LIGHT();
		PixelShader  = compile ps_2_0 PS_LIGHT();
		//FILLMODE= WIREFRAME;
		//CULLMODE= CCW;
		SRCBLEND= ONE;
		DESTBLEND= ONE;
		ALPHABLENDENABLE= true;
    }  
}

technique Ambiant
{
    pass Pass0
    {
		
		VertexShader = compile vs_1_1 VS();
		PixelShader  = compile ps_2_0 PS_AMB();
		//FILLMODE= WIREFRAME;
		//CULLMODE= CCW;
		SRCBLEND= ONE;
		DESTBLEND= ONE;
		ALPHABLENDENABLE= true;
    }  
}							
							