float4x4 matWorldViewProj, matWorld, matTex;

texture tex;
sampler2D texSampler 
{
	Texture	  = (tex);
    MIPFILTER = LINEAR;
    MAGFILTER = LINEAR;
    MINFILTER = LINEAR;
	ADDRESSU= CLAMP;
	ADDRESSV= CLAMP;
};

struct VS_OUTPUT
{
	float4 Pos : POSITION;	
	float light: TEXCOORD0;
	float2 tex: TEXCOORD1;
};



VS_OUTPUT VS(  float4 Pos	: POSITION,  float2 tex:TEXCOORD0, float3 normal	: Normal)
{
   VS_OUTPUT OUT;
	OUT.Pos= mul(Pos, matWorldViewProj );
	normal= mul(normal, (float3x3)matWorld);
	OUT.light= saturate(dot(normal, normalize(float3(1,1,1))));
	OUT.light= saturate(OUT.light+0.5);
	OUT.tex= tex;
	return OUT;
};

float4 PS( VS_OUTPUT IN):COLOR
{
	//return float4(0,1,1,0);
	float4 tex= tex2D(texSampler, IN.tex);
	return IN.light* tex;
};


float4 PSLight( VS_OUTPUT IN):COLOR
{
	return float4(1,1,0,0);
};

technique Simple
{
    pass Pass0
    {
		
		VertexShader = compile vs_1_1 VS();
		PixelShader  = compile ps_2_0 PS();
		//FILLMODE= WIREFRAME;
		//CULLMODE= CCW;
    }  
}
technique LightDebug
{
    pass Pass0
    {
		
		VertexShader = compile vs_1_1 VS();
		PixelShader  = compile ps_2_0 PSLight();
		FILLMODE= WIREFRAME;
		//CULLMODE= CCW;
    }  
}
