﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mexican
{
    public class AudioThing
    {
        public SlimDX.XAudio2.SourceVoice sourceVoice;
        public SlimDX.XAudio2.AudioBuffer audioBuffer;
        public SlimDX.Multimedia.WaveFormat format;
        public bool playing = false;
        /*
        public void sourceVoice_LoopEnd(object sender, SlimDX.XAudio2.ContextEventArgs e)
        {
            throw new NotImplementedException();
        }
         */
        public void sourceVoice_StreamEnd(object sender, EventArgs e)
        {
            //throw new NotImplementedException();
            playing = false;
            if (loop)
            {
                this.sourceVoice = new SlimDX.XAudio2.SourceVoice(AudioManager.device, format);

                AudioManager.Play(this, loop);
            }
        }
        public bool loop = false;

    }
    class AudioManager
    {
        
        public static SlimDX.XAudio2.XAudio2 device;

        public static  void Create()
        {
            device = new SlimDX.XAudio2.XAudio2();

            SlimDX.XAudio2.MasteringVoice masteringVoice = new SlimDX.XAudio2.MasteringVoice(device);

        }

        public static AudioThing Load(string fileName)
        {
            byte[] data;

            AudioThing rez = new AudioThing();
            // read in the wav file
            using (SlimDX.Multimedia.WaveFile file = new SlimDX.Multimedia.WaveFile(fileName))
            {
                rez.format = file.Format;
                data = new byte[file.Size];

                file.Read(data, file.Size);
            }


            rez.sourceVoice = new SlimDX.XAudio2.SourceVoice(device, rez.format);

            // build the wave sample data
            rez.audioBuffer = new SlimDX.XAudio2.AudioBuffer();
            rez.audioBuffer.AudioData = data;
            rez.audioBuffer.AudioBytes = data.Length;
            rez.audioBuffer.Flags = SlimDX.XAudio2.BufferFlags.EndOfStream;

            
            // to set the output speakers, uncomment the following line
            //sourceVoice.SetOutputMatrix(1, 2, new float[] { 1.0f, 0.0f });
            return rez;
        }
        public static void Play(AudioThing audio, bool loop)
        {
            //
            if (audio.playing == false)
            {
                audio.playing = true;
                audio.sourceVoice.SubmitSourceBuffer(audio.audioBuffer);
                audio.sourceVoice.Start();
                //audio.sourceVoice.LoopEnd += new EventHandler<SlimDX.XAudio2.ContextEventArgs>(audio.sourceVoice_LoopEnd); 
                audio.loop = loop;
                audio.sourceVoice.StreamEnd += new EventHandler(audio.sourceVoice_StreamEnd);
            }
        }

        

        

        public static void Stop(AudioThing audio)
        {
            //audio.sourceVoice.SubmitSourceBuffer(audio.audioBuffer);
            audio.sourceVoice.Stop();
            audio.playing = false;
        }

    }
}
