﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mexican
{
    class Game
    {

       public enum GameState
        {
            splashScreen,
            noMexicans,
            withMexicans,
            cought,
            passed,
           gameOver
        }
        public GameState state = GameState.noMexicans;

        public Renderer renderer;
        public Camera camera;
        

        public World world;
        public Player player;

        //public Tower tower1, tower2;
        public Tower[] towers= new Tower[6];

        public bool needToExit = false;

        public bool keyDown, keyUp, keyLeft, keyRight, keyAny, keySpace, keyEsc, keyEnter;

        public int score = 0;

        public System.Collections.Generic.List<Mexican> mexicanCrowd = new System.Collections.Generic.List<Mexican>();
        public System.Collections.Generic.List<Mexican> folowingMexicanList = new System.Collections.Generic.List<Mexican>();

        SlimDX.Direct3D9.Font scoreText;

        SlimDX.Direct3D9.Mesh[] mexicanMeshList = new SlimDX.Direct3D9.Mesh[4];

        public static System.Random rand = new Random();
        private void CreateScoreText()
        {
            System.Drawing.Font f = new System.Drawing.Font("Arial", 20);
            scoreText = new SlimDX.Direct3D9.Font(Program.game.renderer.device, f);
        }
        private void DrawScore()
        {
            scoreText.DrawString(null, "Mexicans brought: "+score.ToString(), 550, 20, new SlimDX.Color4(1, 1, 0, 0));

            int minutes = (Timer.TimeLeft/1000) / 60;
            int seconds = (Timer.TimeLeft/1000) % 60;
            scoreText.DrawString(null, "Time: " + minutes.ToString()+":"+seconds.ToString("00"), 10, 20, new SlimDX.Color4(1, 1, 0, 0));


        }

        AudioThing currentSound;

        //AudioThing[] audioIntro = new AudioThing[2];
        //AudioThing[] follow = new AudioThing[5];
        System.Collections.Generic.List<AudioThing> audioIntro = new List<AudioThing>();
        System.Collections.Generic.List<AudioThing> audioWin = new List<AudioThing>();
        System.Collections.Generic.List<AudioThing> audioFollow = new List<AudioThing>();
        public System.Collections.Generic.List<AudioThing> audioInAmerica = new List<AudioThing>();
        public System.Collections.Generic.List<AudioThing> audioCought = new List<AudioThing>();

        AudioThing gameOverSound;
        SlimDX.Direct3D9.Texture texSpalsh, texEndGame;

       // bool coughtSoundPlayed = false;
        public void LoadSounds()
        {
            //intro
            AudioThing audio= AudioManager.Load(@"data\sounds\intro01.wav");
            audioIntro.Add(audio);

            audio= AudioManager.Load(@"data\sounds\intro02.wav");
            audioIntro.Add(audio);
            /// follow 
            audio = AudioManager.Load(@"data\sounds\andare andare.wav");
            audioFollow.Add(audio);

            audio = AudioManager.Load(@"data\sounds\e chose come here.wav");
            audioFollow.Add(audio);

            audio = AudioManager.Load(@"data\sounds\here i come.wav");
            audioFollow.Add(audio);

            /// in amerika:
            /// 
            audio = AudioManager.Load(@"data\sounds\gracias.wav");
            audioInAmerica.Add(audio);

            audio = AudioManager.Load(@"data\sounds\gracias-pornada.wav");
            audioInAmerica.Add(audio);

            audio = AudioManager.Load(@"data\sounds\nia nia nia.wav");
            audioInAmerica.Add(audio);


            audio = AudioManager.Load(@"data\sounds\we having a fiesta.wav");
            audioInAmerica.Add(audio);

            audio = AudioManager.Load(@"data\sounds\juokas.wav");
            audioInAmerica.Add(audio);


            audio = AudioManager.Load(@"data\sounds\juokas02.wav");
            audioInAmerica.Add(audio);

            ///////////////// PRIGAUTI


            audio = AudioManager.Load(@"data\sounds\where you think youre going.wav");
                audioCought.Add(audio);

                audio = AudioManager.Load(@"data\sounds\ai caramba grumble.wav");
                audioCought.Add(audio);


                audio = AudioManager.Load(@"data\sounds\dont move.wav");
                audioCought.Add(audio);

                gameOverSound = AudioManager.Load(@"data\sounds\pabaigai.wav");
        }
        public bool Start()
        {

            state = GameState.splashScreen;
            renderer = new Renderer();
            renderer.Create();


            texSpalsh = renderer.LoadTexture("data\\splash.bmp");
            texEndGame = renderer.LoadTexture("data\\endGame.bmp");
            CreateScoreText();

            world = new World();
            world.Create();

            player = new Player();
            player.Create();

            camera = new Camera();
            camera.Create(player);

            AudioManager.Create();

           // sound = AudioManager.Load("data\\followME.wav");

            LoadSounds();
            currentSound = audioIntro[0];
            AudioManager.Play(currentSound, true);
            //sound = AudioManager.Load("data\\mp3.mp3");
            

            mexicanMeshList[2]= SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\meks.x", SlimDX.Direct3D9.MeshFlags.Managed);
            mexicanMeshList[0] = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\berniukas.X", SlimDX.Direct3D9.MeshFlags.Managed);
            mexicanMeshList[1] = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\mergaite.X", SlimDX.Direct3D9.MeshFlags.Managed);
            mexicanMeshList[3] = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\moteris.X", SlimDX.Direct3D9.MeshFlags.Managed);

            CreateMaxicanCrowd(20);
             towers[0] = new Tower();
             towers[0].Create(new SlimDX.Vector3(-13, 0,-20), new SlimDX.Vector2(-8, -30), new SlimDX.Vector2(10, -10));

             towers[1] = new Tower();
             towers[1].Create(new SlimDX.Vector3(-10, 0, -13), new SlimDX.Vector2(-7.5f, -17), new SlimDX.Vector2(14, -6));

            //////////////////////////////////


             towers[2] = new Tower();
             towers[2].Create(new SlimDX.Vector3(6, 0, 1), new SlimDX.Vector2(9, -10), new SlimDX.Vector2(22, 18));

             towers[3] = new Tower();
             towers[3].Create(new SlimDX.Vector3(-18, 0, 12), new SlimDX.Vector2(-24, -7), new SlimDX.Vector2(-10, 8));

             towers[4] = new Tower();
             towers[4].Create(new SlimDX.Vector3(-34, 0, 5), new SlimDX.Vector2(-32, -7), new SlimDX.Vector2(-24, 16));

             towers[5] = new Tower();
             towers[5].Create(new SlimDX.Vector3(28, 0, 18), new SlimDX.Vector2(13, -6), new SlimDX.Vector2(39, 14));


            return true;
        }
        public void Run()
        {
            Timer.Start();
            while (!needToExit)
            {
                System.Windows.Forms.Application.DoEvents();
                Update();

                keyAny = false;
            }

        }
        public int transported = 1;
        int taken = 1;

        void DrawGameOverScore()
        {
            scoreText.DrawString(null, score.ToString(), 500, 125, new SlimDX.Color4(1, 1, 0, 0));
        }
        public void Update()
        {
            if (Timer.TimeLeft <= 0)
            {
                state = GameState.gameOver;
            }

            renderer.BeginRender();

//            if (state == GameState.splashScreen)
  //          {
            switch (state)
            {
                case GameState.splashScreen:
                renderer.DrawQuad(new SlimDX.Vector2(2, 2), new SlimDX.Vector2(-1, -1), texSpalsh);

                if (keyAny)
                {
                    state = GameState.noMexicans;
                    AudioManager.Stop(currentSound);
                    Timer.Start();
                }

                break;
    //        }
      //      else
                case GameState.gameOver:
                renderer.DrawQuad(new SlimDX.Vector2(2, 2), new SlimDX.Vector2(-1, -1), texEndGame);
                AudioManager.Play(gameOverSound, true);
                DrawGameOverScore();
                if (keyEsc)
                {
                    this.needToExit = true;
                }
                else if (keyEnter)
                {
                    AudioManager.Stop(gameOverSound);
                    state = GameState.noMexicans;
                    Timer.Start();
                    score = 0;
                    transported = 0;
                    taken = 0;
                    player.Create();
                    CreateMaxicanCrowd(20);
                    folowingMexicanList.Clear();
                }

                break;
                default:
                Timer.Update();
                PlayerControls();

                camera.Update();

                foreach (Mexican m in mexicanCrowd)
                    m.Update();


                int count = mexicanCrowd.Count;

                for (int i = 0; i < count; i++)
                {
                    if (mexicanCrowd[i].currentState == Mexican.state.far)
                    {
                        // mexicanCrowd.Remove(mexicanCrowd[i]);
                        // i--;
                        // count--;

                        mexicanCrowd[i].currentState = Mexican.state.stopped;

                        mexicanCrowd[i].pos = RandomMexicanPoint();

                       

                        //mexicanCrowd.Add(m);

                    }
                    if (mexicanCrowd[i].currentState == Mexican.state.inAmerica)
                    {
                        if (mexicanCrowd.Count <= taken + 10)
                        {
                            Mexican m = new Mexican();

                            m.Create(RandomMexicanPoint(), player, mexicanMeshList[0]);
                            mexicanCrowd.Add(m);
                        }
                    }
                    // if (mexicanCrowd[i].currentState == Mexican.state.inAmerica)
                    // {
                    // transported++;
                    // }
                }

                foreach (Tower t in towers)
                    t.Update();
                


                player.Render();
                world.Render();



                foreach (Tower t in towers)
                    t.Render();
                foreach (Mexican m in mexicanCrowd)
                    m.Render();




                DrawScore();
                    break;
            
        }
            renderer.EndRender();
        }

        public SlimDX.Vector3 RandomMexicanPoint()
        {
            SlimDX.Vector2 zoneMin = new SlimDX.Vector2(-10, -50);
            SlimDX.Vector2 zoneMax = new SlimDX.Vector2(10, -40);

            SlimDX.Vector2 p = new SlimDX.Vector2(zoneMin.X + (zoneMax.X - zoneMin.X) * (float)rand.NextDouble(),
                                 zoneMin.Y + (zoneMax.Y - zoneMin.Y) * (float)rand.NextDouble());

            return new SlimDX.Vector3(p.X, 0, p.Y);
        }
        public void CreateMaxicanCrowd(uint count)
        {
            

            mexicanCrowd.Clear();

            for (int i = 0; i < count; i++)
            {
            
                

                Mexican m = new Mexican();

                m.Create(RandomMexicanPoint(), player, mexicanMeshList[randomInt( mexicanMeshList.Length-1)]);
                //m.Create(RandomMexicanPoint(), player, mexicanMeshList[3]);

                mexicanCrowd.Add(m);
            }
        }

        public static int randomInt(int max)
        {
            return rand.Next(0, max);
        }
        public void PlayerControls()
        {
            int forward = 0;
            int side = 0;

            if (keyUp)
                forward++;

            if (keyDown)
                forward--;
            if (keyLeft)
                side--;

            if (keyRight)
                side++;

            player.Move(forward, side);

            if (keySpace)
            {
            //    foreach (Mexican m in mexicanList)
              //      m.StartFollow();
                if (folowingMexicanList.Count == 0)
                {
                    if (player.pos.Z <= -40)
                    {
                        AudioManager.Play(audioFollow[randomInt(audioFollow.Count-1)] , false);
                        //  AudioManager.Stop(sound);


                        int followCount = transported + 4;
                        for (int i = 0; i < followCount; i++)
                        {
                            if (i < mexicanCrowd.Count - 1)
                            {
                                if (mexicanCrowd[i].currentState == Mexican.state.stopped)
                                {
                                    folowingMexicanList.Add(mexicanCrowd[i]);
                                    mexicanCrowd[i].StartFollow();
                                    //   mexicanCrowd.Remove(mexicanCrowd[0]);
                                }
                                else
                                {
                                    followCount++;
                                }
                            }
                        }
                        transported = 0;
                        taken = followCount;
                    }
                    state = GameState.withMexicans;
                }
            }

            if (keyEsc)
                needToExit = true;
        }
    }
}
