﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mexican
{
    class Mexican
    {
        public enum state
        {
            stopped,
            following,
            cought,
            inAmerica,
            far,
            deported
        }

        public state currentState = state.stopped;
        public float speed = 1.0f;

        public SlimDX.Vector3 pos;
        public SlimDX.Direct3D9.Mesh mesh;
        public SlimDX.Matrix mat;

        public static SlimDX.Direct3D9.Effect effect;
        public static SlimDX.Direct3D9.Texture[] textures;
        SlimDX.Direct3D9.ExtendedMaterial[] materials;
        Player player;

        float maxDistToPlayer;

        public bool Create(SlimDX.Vector3 pos, Player player, SlimDX.Direct3D9.Mesh mesh)
        {
            //mesh = SlimDX.Direct3D9.Mesh.CreateBox(Program.game.renderer.device, 1, 1, 1);
            this.mesh = mesh;
            materials = mesh.GetMaterials();

            textures = new SlimDX.Direct3D9.Texture[materials.Length];
            for (int i = 0; i < materials.Length; i++)
            {
                materials[i].TextureFileName = materials[i].TextureFileName.Substring(0, materials[i].TextureFileName.Length - 3) + "dds";
                //textures[i] = SlimDX.Direct3D9.Texture.FromFile(Program.game.renderer.device, "data\\" + materials[i].TextureFileName);
                textures[i] = Program.game.renderer.LoadTexture("data\\" + materials[i].TextureFileName);
            }
            //mesh.GetMaterials();
            mat = SlimDX.Matrix.Translation(0, 0.5f, 0);

            if (effect == null)
                effect = Program.game.renderer.LoadEffect("mexican.fx");


            this.player = player;
            this.pos = pos;

            speed = player.speed * 1;
            return true;
        }

        public void StartFollow()
        {
            currentState = state.following;

            maxDistToPlayer = 5;//(pos - Program.game.player.pos).Length();

        }

        SlimDX.Vector3 target = new SlimDX.Vector3();

        public SlimDX.Vector3 KeepDistance()
        {
            float distToKeep = 2.5f;
            float minDist = float.MaxValue;
            SlimDX.Vector3 vToClosest = new SlimDX.Vector3();
            foreach (Mexican m in Program.game.mexicanCrowd)
            {
                if (m == this)
                    continue;
                float dist = (m.pos - pos).LengthSquared();
                if (dist <= minDist && dist < distToKeep)
                {
                    vToClosest = (m.pos - pos);
                }

            }
            vToClosest.Normalize();
            return vToClosest;
        }

        private SlimDX.Vector3 returnTo;

        float wait = 0;
        static float delay = 0;
        static float delayCought = 0;
        public void Update()
        {
            float var = 0.9f;

            SlimDX.Vector3 toPlayer = (Program.game.player.pos - pos);
            toPlayer.Normalize();

            
            switch (currentState)
            {
                case state.following:

                    // if (currentState == state.following)
                    //{
                    float currentDist = (pos - Program.game.player.pos).Length();

                    //palaiko atstuma tarp meksikieciu:
                    SlimDX.Vector3 vToClosest = KeepDistance();

                    float minDistToPlayer = 1.5f;
                    if (!(currentDist * var >= maxDistToPlayer))
                    {
                        //zaidejas per arti, pasitraukia
                        if (currentDist <= minDistToPlayer)
                        {

                            toPlayer = -SlimDX.Vector3.Reflect(toPlayer, -player.moveDir);
                            //toPlayer = SlimDX.Vector3.Cross(toPlayer, new SlimDX.Vector3(0, 1, 0));
                        }
                        else //nieko nedaro
                        {

                            toPlayer = new SlimDX.Vector3(0, 0, 0);
                        }



                        //pos += toPlayer * speed * Timer.DeltaTime;
                    }

                    // Math.Abs(vToClosest.X);
                    //  Math.Abs(vToClosest.Y);
                    // Math.Abs(vToClosest.Z);

                    SlimDX.Vector3 moveDir = toPlayer - vToClosest * 0.5f;

                    pos += moveDir * speed * Timer.DeltaTime;
                    //}
                    //    break;
                    //  case state.stopped:


                    target = (Program.game.player.pos - pos);
                    if (pos.Z > 23)
                    {
                        Program.game.transported++;
                        Program.game.folowingMexicanList.Remove(this);
                        currentState = state.inAmerica;
                        Program.game.score++;
                        target = new SlimDX.Vector3((float)(Game.rand.NextDouble() * 0.8) - 0.4f,0, 1);

                        target.Normalize();
                        if (delay == 0)
                        {
                            AudioManager.Play(Program.game.audioInAmerica[Game.randomInt(Program.game.audioInAmerica.Count - 1)], false);
                            delay += Timer.DeltaTime;
                        }
                        else
                        {
                            delay += Timer.DeltaTime;
                            if (delay >= 3)
                            {
                                delay = 0;
                            }
                        }
                    }
                    break;
                case state.stopped:
                    SlimDX.Vector3 toClosest = KeepDistance();
                    SlimDX.Vector3 vMoveDir = toClosest * 0.5f;

                    pos += -vMoveDir * speed * Timer.DeltaTime;

                    target = (Program.game.player.pos - pos);
                    break;
                case state.inAmerica:

                    pos += target * speed * Timer.DeltaTime * 1.5f ;

                    if (pos.Z > 50)
                    {
                        //Program.game.mexicanCrowd.Remove(this);
                        currentState = state.far;

                    }
                    break;
                case state.far:
                    
                    break;
                case state.cought:
                    if (delayCought == 0)
                    {
                        delayCought += 0.1f ;
                        AudioManager.Play(Program.game.audioCought[Game.randomInt(Program.game.audioCought.Count - 1)], false);
                        
                    }
                    else
                    {
                        delayCought += Timer.DeltaTime;
                        if (delayCought >= 10)
                        {
                            delayCought = 0;
                        }
                    }
                    Program.game.folowingMexicanList.Remove(this);

                    returnTo = Program.game.RandomMexicanPoint();

                    wait += Timer.DeltaTime;
                    if (wait >= 3)
                    {
                        currentState = state.deported;
                        wait = 0;
                    }

                    
                    break;
                case state.deported:
                    target = -(pos - returnTo);

                    if (target.Length() < 0.5)
                        currentState = state.stopped;
                    
                    target.Normalize();
                    pos += target * speed * Timer.DeltaTime;

                    
                    break;
                    
            }

            if (currentState != state.far)
            {
                mat = SlimDX.Matrix.LookAtLH(new SlimDX.Vector3(0, 0, 0), -target, new SlimDX.Vector3(0, 1, 0));
                mat.Invert();
                mat *= SlimDX.Matrix.Translation(pos.X, 0.5f, pos.Z);
            }
        }
        public void Render()
        {
            if (currentState != state.far)
            {
                /*effect.Technique = "Simple";

                effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);
                effect.SetValue<SlimDX.Matrix>("matWorld", mat);

                effect.Begin(0);
                effect.BeginPass(0);

                for (int i = 0; i < textures.Length; i++)
                {
                    effect.SetTexture("tex", textures[i]);
                    effect.CommitChanges();
                    mesh.DrawSubset(i);
                }
                // mesh.DrawSubset(0);

                effect.EndPass();
                effect.End();
                 */
                effect.Technique = "LightFirst";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);
            effect.SetValue<SlimDX.Matrix>("matWorld", mat);
            effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.towers[0].matProjector);

            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);

            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            //////////////////////////////
            effect.Technique = "Light";
            foreach (Tower t in Program.game.towers)
            {
                effect.SetValue<SlimDX.Matrix>("matProjector", t.matProjector);

                effect.SetTexture("texLight", Program.game.renderer.texLight);
                effect.Begin(0);
                effect.BeginPass(0);

                for (int i = 0; i < textures.Length; i++)
                {
                    effect.SetTexture("tex", textures[i]);
                    effect.CommitChanges();
                    mesh.DrawSubset(i);
                }

                effect.EndPass();
                effect.End();
            }
            /////////////////////////////
            effect.Technique = "Ambiant";
            //          effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.tower2.matProjector);

            //            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);

            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();

            //////////////

            effect.Technique = "Simple";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            //effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            
        }

            
        }
    }
}
