﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mexican
{
    class Player
    {
        public float speed = 10.0f;

        public SlimDX.Vector3 pos;
        public SlimDX.Direct3D9.Mesh mesh;
        public SlimDX.Matrix mat;

        public SlimDX.Direct3D9.Effect effect;

        public SlimDX.Vector3 moveDir= new SlimDX.Vector3(0,0,1);

        public static SlimDX.Direct3D9.Texture[] textures;
        SlimDX.Direct3D9.ExtendedMaterial[] materials;

        public bool Create()
        {
            //mesh = SlimDX.Direct3D9.Mesh.CreateBox(Program.game.renderer.device, 1, 1, 1);
            mesh = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\player.X", SlimDX.Direct3D9.MeshFlags.Managed);
            materials = mesh.GetMaterials();

            textures = new SlimDX.Direct3D9.Texture[materials.Length];
            for (int i = 0; i < materials.Length; i++)
            {
                materials[i].TextureFileName = materials[i].TextureFileName.Substring(0, materials[i].TextureFileName.Length - 3) + "dds";
                //textures[i] = SlimDX.Direct3D9.Texture.FromFile(Program.game.renderer.device, "data\\" + materials[i].TextureFileName);
                textures[i] = Program.game.renderer.LoadTexture("data\\" + materials[i].TextureFileName);
            }

            pos = new SlimDX.Vector3(0, 0, -20);
            mat = SlimDX.Matrix.Translation(0, 0.0f, 0);

            effect = Program.game.renderer.LoadEffect("player.fx");

            return true;
        }


       
        public void Move(int forward, int side)
        {
            float deltaT = Timer.DeltaTime;

            //moveDir = pos;

            mat = SlimDX.Matrix.Identity;

            //float rad= (float)(180.0/Math.PI);
            //float angle = 0;
            SlimDX.Vector3 move = new SlimDX.Vector3();
            bool moved = false;
            if (forward > 0)
            {
                move.Z += speed* deltaT;
                moved = true;
                
            }
            if (forward < 0)
            {
                move.Z -= speed * deltaT;
                moved = true;
                //mat *= SlimDX.Matrix.RotationY(180.0f / rad);
               // angle += 180;
            }

            if (side > 0)
            {
                move.X += speed * deltaT;
                moved = true;
               // mat *= SlimDX.Matrix.RotationY(90.0f / rad);
            }
            if (side < 0)
            {
                move.X -= speed * deltaT;
                moved = true;
                //mat *= SlimDX.Matrix.RotationY(90.0f / rad);
            }
            if (moved && move.LengthSquared() > 0.001f)
                moveDir = move;

            SlimDX.Vector3 ray= move;
            ray.Normalize();
            float maxDist= move.Length();
            SlimDX.Vector3 normal;
            if (Program.game.world.testColision(pos, ray, maxDist, out normal) == false)
            {

                pos += move;
            }
            else
            {
                //pos -= normal * 0.1f;
            }
            mat = SlimDX.Matrix.LookAtLH(new SlimDX.Vector3(0, 0, 0), -moveDir, new SlimDX.Vector3(0, 1, 0));
            mat.Invert();
            mat *= SlimDX.Matrix.Translation(pos.X, 0.5f, pos.Z);

            
        }
        public void Render()
        {
  /*          effect.Technique = "Simple";
            
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat*Program.game.camera.matView * Program.game.camera.matProj);
            effect.SetValue<SlimDX.Matrix>("matWorld", mat);
            effect.Begin(0);
            effect.BeginPass(0);

            //mesh.DrawSubset(0);
            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            */
            effect.Technique = "LightFirst";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);
            effect.SetValue<SlimDX.Matrix>("matWorld", mat);
            effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.towers[0].matProjector);

            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);

            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            //////////////////////////////
            foreach (Tower t in Program.game.towers)
            {
                effect.Technique = "Light";
                effect.SetValue<SlimDX.Matrix>("matProjector", t.matProjector);

                effect.SetTexture("texLight", Program.game.renderer.texLight);
                effect.Begin(0);
                effect.BeginPass(0);

                for (int i = 0; i < textures.Length; i++)
                {
                    effect.SetTexture("tex", textures[i]);
                    effect.CommitChanges();
                    mesh.DrawSubset(i);
                }
                effect.EndPass();
                effect.End();
            }
            

            /////////////////////////////
            effect.Technique = "Ambiant";
            //          effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.tower2.matProjector);

            //            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);

            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();

            //////////////

            effect.Technique = "Simple";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            //effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            
        }


    }
}
