﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mexican
{
    class Renderer
    {

        public static SlimDX.Direct3D9.VertexBuffer VBQuad = null;
        public static SlimDX.Direct3D9.VertexDeclaration decl = null;


        private SlimDX.Direct3D9.Direct3D D3D;
        public SlimDX.Direct3D9.Device device;

        private System.Collections.Generic.SortedDictionary<string, SlimDX.Direct3D9.Texture> textureList= new  System.Collections.Generic.SortedDictionary<string, SlimDX.Direct3D9.Texture>();


        public SlimDX.Direct3D9.Texture texLight;
        public SlimDX.Direct3D9.Texture LoadTexture(string fileName)
        {
            SlimDX.Direct3D9.Texture rez;
            if (textureList.TryGetValue(fileName, out rez)== false)
            {
                rez= SlimDX.Direct3D9.Texture.FromFile(Program.game.renderer.device, fileName);

                textureList.Add(fileName, rez);

            }
            return rez;
        }

        SlimDX.Direct3D9.Effect effect;
        public bool Create()
        {
            D3D = new SlimDX.Direct3D9.Direct3D();

            SlimDX.Direct3D9.PresentParameters presentParams = new SlimDX.Direct3D9.PresentParameters();
            presentParams.BackBufferHeight = Program.mainForm.Size.Height;
            presentParams.BackBufferWidth = Program.mainForm.Size.Width;
            presentParams.DeviceWindowHandle = Program.mainForm.Handle;
            presentParams.EnableAutoDepthStencil = true;
            presentParams.AutoDepthStencilFormat = SlimDX.Direct3D9.Format.D24X8;

            presentParams.Windowed = true;
            if (presentParams.Windowed == false)
                presentParams.FullScreenRefreshRateInHertz = 60;
            device = new SlimDX.Direct3D9.Device(D3D, 0, SlimDX.Direct3D9.DeviceType.Hardware, Program.mainForm.Handle, SlimDX.Direct3D9.CreateFlags.HardwareVertexProcessing, presentParams);



            texLight = LoadTexture("data\\light.dds");

            ////////////////

            float z = 0;

            SlimDX.Vector3[] quad = new SlimDX.Vector3[] 
            {
                    new SlimDX.Vector3(0, 0,z),
                    new SlimDX.Vector3(1, 0,z),
                    new SlimDX.Vector3(1, 1,z),
                    new SlimDX.Vector3(0, 1,z)
            };
            VBQuad = new SlimDX.Direct3D9.VertexBuffer(device, quad.Length * System.Runtime.InteropServices.Marshal.SizeOf(typeof(SlimDX.Vector3)), SlimDX.Direct3D9.Usage.WriteOnly, SlimDX.Direct3D9.VertexFormat.None, SlimDX.Direct3D9.Pool.Managed);

            SlimDX.DataStream stream = VBQuad.Lock(0, 0, SlimDX.Direct3D9.LockFlags.None);

            stream.WriteRange(quad, 0, quad.Length);
            VBQuad.Unlock();

            SlimDX.Direct3D9.VertexElement[] elem = new SlimDX.Direct3D9.VertexElement[]
            {
              new SlimDX.Direct3D9.VertexElement(0, 0, SlimDX.Direct3D9.DeclarationType.Float3, SlimDX.Direct3D9.DeclarationMethod.Default, SlimDX.Direct3D9.DeclarationUsage.Position, 0),
              SlimDX.Direct3D9.VertexElement.VertexDeclarationEnd
            };
            decl = new SlimDX.Direct3D9.VertexDeclaration(device, elem);


            effect = LoadEffect("2d.fx");
            return true;
        }

        public void DrawQuad(SlimDX.Vector2 scale, SlimDX.Vector2 offset, SlimDX.Direct3D9.Texture tex)
        {
            effect.Technique = "Simple";

            effect.SetValue<SlimDX.Vector4>("info",new SlimDX.Vector4(scale, offset.X, offset.Y));
            effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);


            device.VertexDeclaration = decl;
            //device.VertexFormat = SlimDX.Direct3D9.VertexFormat.PositionW| SlimDX.Direct3D9.VertexFormat.Texture0;

            device.SetStreamSource(0, VBQuad, 0, System.Runtime.InteropServices.Marshal.SizeOf(typeof(SlimDX.Vector3)));

            device.DrawPrimitives(SlimDX.Direct3D9.PrimitiveType.TriangleFan, 0, 2);
            effect.EndPass();
            effect.End();
            

        }

        public void  BeginRender()
        {
            device.Clear(SlimDX.Direct3D9.ClearFlags.Target | SlimDX.Direct3D9.ClearFlags.ZBuffer, System.Drawing.Color.Beige, 1, 0);
            device.BeginScene();

            

        }
        public void EndRender()
        {
            device.EndScene();
            device.Present();
        }

        public SlimDX.Direct3D9.Effect LoadEffect(string fileName)
        {
            String err = "msg";
            SlimDX.Direct3D9.Effect effect= null;
            try
            {
                effect = SlimDX.Direct3D9.Effect.FromFile(device, "Data\\" + fileName, null, null, null, SlimDX.Direct3D9.ShaderFlags.Debug | SlimDX.Direct3D9.ShaderFlags.PartialPrecision, null, out err);
            }
            catch (Exception e)
            {
                // MessageBox.Show(e.ToString());
                System.Windows.Forms.MessageBox.Show(err);
            }
            if (err.Length != 0)
                System.Windows.Forms.MessageBox.Show(err);

            return effect;
        }
    }
}
