﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mexican
{
    class Tower
    {

        public enum State
        {
            seaching,
            found
        }

        State towerState = State.seaching;


        public SlimDX.Vector3 pos;
        public SlimDX.Direct3D9.Mesh mesh;

        public SlimDX.Direct3D9.Mesh meshLightDebug;


        public SlimDX.Matrix mat;

        public static SlimDX.Direct3D9.Effect effect;

        SlimDX.Vector2 zoneMin, zoneMax;

        private static System.Random rand= new Random();
        float lightSpeed = 0.1f;

        SlimDX.Vector2[] lightKeyFrames = new SlimDX.Vector2[4];
        float keyFrameTime = 0;
        float currentTime = 0;

        SlimDX.Vector2 lightPos;
        float lightRadius = 4;

        public static SlimDX.Direct3D9.Texture[] textures;
        SlimDX.Direct3D9.ExtendedMaterial[] materials;

        public bool Create(SlimDX.Vector3 pos, SlimDX.Vector2 zoneMin, SlimDX.Vector2 zoneMax)
        {
            //mesh = SlimDX.Direct3D9.Mesh.CreateBox(Program.game.renderer.device, 5, 15, 5);

         /*   mesh = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\bokstelis.x", SlimDX.Direct3D9.MeshFlags.Managed);
            materials = mesh.GetMaterials();

            textures = new SlimDX.Direct3D9.Texture[materials.Length];
            for (int i = 0; i < materials.Length; i++)
            {
                materials[i].TextureFileName = materials[i].TextureFileName.Substring(0, materials[i].TextureFileName.Length - 3) + "dds";
                textures[i] = SlimDX.Direct3D9.Texture.FromFile(Program.game.renderer.device, "data\\" + materials[i].TextureFileName);
            }

            */
            meshLightDebug = SlimDX.Direct3D9.Mesh.CreateSphere(Program.game.renderer.device, lightRadius, 10, 10);


            mat = SlimDX.Matrix.Translation( new SlimDX.Vector3( 0, 0, 0) + pos);

            if (effect == null) 
                effect = Program.game.renderer.LoadEffect("tower.fx");

            this.pos = pos;

            this.zoneMin = zoneMin;
            this.zoneMax = zoneMax;


            for (int i = 0; i < 4; i++)
            {
                lightKeyFrames[i] = RandomPoint();
            }
            keyFrameTime = (lightKeyFrames[1] - lightKeyFrames[2]).Length() * lightSpeed;

            return true;
        }
        public SlimDX.Vector2 RandomPoint()
        {

            return new SlimDX.Vector2(zoneMin.X + (zoneMax.X - zoneMin.X) * (float)rand.NextDouble(),
                            zoneMin.Y + (zoneMax.Y - zoneMin.Y) * (float)rand.NextDouble());
        }
        public void Render()
        {
          /*  effect.Technique = "Simple";

            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);
            effect.SetValue<SlimDX.Matrix>("matWorld", mat);
            effect.Begin(0);
            effect.BeginPass(0);

            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }
            //mesh.DrawSubset(0);

            effect.EndPass();
            effect.End();
            */
            
           /* effect.Technique = "LightDebug";

            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", SlimDX.Matrix.Translation(lightPos.X, 0, lightPos.Y) * Program.game.camera.matView * Program.game.camera.matProj);
            effect.SetValue<SlimDX.Matrix>("matWorld", mat);
            effect.Begin(0);
            effect.BeginPass(0);

            
            meshLightDebug.DrawSubset(0);

            effect.EndPass();
            effect.End();
           */
        }

        float spottedTime;
        private void CatchMexicans()
        {
            foreach (Mexican m in Program.game.folowingMexicanList)
            {
                if ((new SlimDX.Vector2(m.pos.X, m.pos.Z) - lightPos).LengthSquared() <= lightRadius * lightRadius)
                {
                    if (m.currentState != Mexican.state.cought && m.currentState != Mexican.state.deported)
                    {
                        //pagavo
                        towerState = State.found;
                        Program.game.state = Game.GameState.cought;
                        m.currentState = Mexican.state.cought;
                        //lightPos = new SlimDX.Vector2(m.pos.X, m.pos.Z);
                        break;
                    }
                }
            }
        }

        public SlimDX.Matrix matProjector;
        public void Update()
        {
            if (towerState == State.seaching)
            {
                spottedTime = 0;
                if (currentTime <= keyFrameTime)
                {
                    lightPos = SlimDX.Vector2.CatmullRom(lightKeyFrames[0], lightKeyFrames[1],
                                                        lightKeyFrames[2], lightKeyFrames[3],
                                                        currentTime / keyFrameTime);

                    currentTime += Timer.DeltaTime;

                }
                else
                {
                    lightKeyFrames[0] = lightKeyFrames[1];
                    lightKeyFrames[1] = lightKeyFrames[2];
                    lightKeyFrames[2] = lightKeyFrames[3];
                    lightKeyFrames[3] = RandomPoint();
                    keyFrameTime = (lightKeyFrames[1] - lightKeyFrames[2]).Length() * lightSpeed;
                    currentTime = 0;
                }

                CatchMexicans();

                /* if (Program.game.state==Game.GameState.withMexicans)
                 {
                     if ((new SlimDX.Vector2(Program.game.player.pos.X, Program.game.player.pos.Z) - lightPos).LengthSquared() <= lightRadius * lightRadius)
                     {
                         //pagavo
                         Program.game.state = Game.GameState.cought;
                     }
                 }
                 * */
            }
            else
            {
                CatchMexicans();
                spottedTime += Timer.DeltaTime;

                if (spottedTime >= 5)
                {
                    towerState = State.seaching;
                }
            }
            matProjector = SlimDX.Matrix.LookAtLH(pos + new SlimDX.Vector3(0, 20, 0), new SlimDX.Vector3(lightPos.X, 0, lightPos.Y), new SlimDX.Vector3(0, 1, 0));

            matProjector *= SlimDX.Matrix.PerspectiveFovLH((float)(Math.PI / 8.0f), 1.33f, 1.0f, 100.0f);
        }
    }
}
