﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Mexican
{
    class World
    {

        public SlimDX.Direct3D9.Mesh mesh;
        public SlimDX.Direct3D9.Mesh meshTvora;
        public SlimDX.Matrix mat;

        public SlimDX.Direct3D9.Effect effect;

        public SlimDX.Direct3D9.Texture tex;

        public SlimDX.Direct3D9.Mesh meshColision;
        public SlimDX.Direct3D9.Mesh meshKalnai;
        public static SlimDX.Direct3D9.Texture[] textures;

        public static SlimDX.Direct3D9.Texture[] texturesTvora;
        public static SlimDX.Direct3D9.Texture[] texturesKalnai;

        SlimDX.Direct3D9.ExtendedMaterial[] materials;


        public bool Create()
        {
           // mesh = SlimDX.Direct3D9.Mesh.CreateBox(Program.game.renderer.device, 100, 1, 100);
            mesh = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\lygisZeme.X", SlimDX.Direct3D9.MeshFlags.Managed);


            materials = mesh.GetMaterials();

            textures = new SlimDX.Direct3D9.Texture[materials.Length];
            for (int i = 0; i < materials.Length; i++)
            {
                materials[i].TextureFileName = materials[i].TextureFileName.Substring(0, materials[i].TextureFileName.Length - 3) + "dds";
                //textures[i] = SlimDX.Direct3D9.Texture.FromFile(Program.game.renderer.device, "data\\" + materials[i].TextureFileName);
                textures[i] =  Program.game.renderer.LoadTexture("data\\" + materials[i].TextureFileName);
            }



            meshTvora = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\lygisTvora.X", SlimDX.Direct3D9.MeshFlags.Managed);

            materials = meshTvora.GetMaterials();
            texturesTvora = new SlimDX.Direct3D9.Texture[materials.Length];
            for (int i = 0; i < materials.Length; i++)
            {
                materials[i].TextureFileName = materials[i].TextureFileName.Substring(0, materials[i].TextureFileName.Length - 3) + "dds";
                //textures[i] = SlimDX.Direct3D9.Texture.FromFile(Program.game.renderer.device, "data\\" + materials[i].TextureFileName);
                texturesTvora[i] = Program.game.renderer.LoadTexture("data\\" + materials[i].TextureFileName);
            }

            meshKalnai = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\kalnai.X", SlimDX.Direct3D9.MeshFlags.Managed);

            materials = meshKalnai.GetMaterials();
            texturesKalnai = new SlimDX.Direct3D9.Texture[materials.Length];
            for (int i = 0; i < materials.Length; i++)
            {
                materials[i].TextureFileName = materials[i].TextureFileName.Substring(0, materials[i].TextureFileName.Length - 3) + "dds";
                //textures[i] = SlimDX.Direct3D9.Texture.FromFile(Program.game.renderer.device, "data\\" + materials[i].TextureFileName);
                texturesKalnai[i] = Program.game.renderer.LoadTexture("data\\" + materials[i].TextureFileName);
            }

            meshColision = SlimDX.Direct3D9.Mesh.FromFile(Program.game.renderer.device, "data\\kolizija.X", SlimDX.Direct3D9.MeshFlags.SystemMemory);


            mat = SlimDX.Matrix.Translation(0, 0, 0);

            effect = Program.game.renderer.LoadEffect("world.fx");

            //tex = Program.game.renderer.LoadTexture("data\\zeme.dds");
            LoadCollision();
            return true;
        }

        class Triangle
        {
            public SlimDX.Vector3[] v = new SlimDX.Vector3[3];
            public SlimDX.Vector3 n = new SlimDX.Vector3();
        }
        class Vertex
        {
            public SlimDX.Vector3 v = new SlimDX.Vector3();
            public SlimDX.Vector3 n = new SlimDX.Vector3();
        }

        Triangle[] triList;
        public void LoadCollision()
        {
            triList = new Triangle[meshColision.FaceCount];

            SlimDX.DataStream dsIndex= meshColision.LockIndexBuffer(SlimDX.Direct3D9.LockFlags.ReadOnly);
            SlimDX.DataStream dsVertex = meshColision.LockVertexBuffer(SlimDX.Direct3D9.LockFlags.ReadOnly);

            ushort[] IB = dsIndex.ReadRange<ushort>(meshColision.FaceCount * 3);
            
            Vertex[] VB= new Vertex[meshColision.VertexCount];
            for (int i = 0; i < meshColision.VertexCount; i++ )
            {
                VB[i] = new Vertex();
                VB[i].v = dsVertex.Read<SlimDX.Vector3>();
                dsVertex.Read<SlimDX.Vector2>();
                VB[i].n = dsVertex.Read<SlimDX.Vector3>();
            }
            //triList ds.Read<SlimDX.Vector3>()

            for (int i = 0; i < meshColision.FaceCount; i++)
            {
                triList[i] = new Triangle();
                //triList[i].v = new SlimDX.Vector3[3];
                //triList[i].n = new SlimDX.Vector3();

                triList[i].v[0] = VB[IB[i*3+0]].v;
                triList[i].v[1] = VB[IB[i * 3 + 1]].v;
                triList[i].v[2] = VB[IB[i * 3 + 2]].v;

                triList[i].n = VB[IB[i * 3 + 0]].n;

            }
        }
        public bool testColision(SlimDX.Vector3 pos, SlimDX.Vector3 dir, float maxDist, out SlimDX.Vector3 normal)
        {
            SlimDX.Ray ray = new SlimDX.Ray(pos, dir);
            float dist;
            normal = new SlimDX.Vector3();
            /*int index = 0;
            
            SlimDX.Direct3D9.IntersectInformation[] info;
            if (meshColision.Intersects(ray, out dist, out index, out info))
            {
                //mesh.
                //if ( Math.Abs(dist) > Math.Abs(maxDist))
                 //   return false;

                //info[0].
                //meshColision.get
                return true;

            }
             * */

            float minDist = float.MaxValue;
            bool rez = false;
            for (int i = 0; i < triList.Length; i++)
            {
                if (SlimDX.Ray.Intersects(ray, triList[i].v[0], triList[i].v[1], triList[i].v[2], out dist))
                {
                    rez = true;
                    if (dist < minDist)
                    {
                        minDist = dist;
                        normal = triList[i].n;
                    }
                }
            }
            if (rez)
            {
                if (minDist <= maxDist)
                    return true;
                return false;
            }

            return false ;
        }

        public void Render()
        {
            /*effect.Technique = "Simple";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            mesh.DrawSubset(0);

            effect.EndPass();
            effect.End();
            */

            effect.Technique = "LightFirst";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);
            effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.towers[0].matProjector);

            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);

            
            //mesh.DrawSubset(0);
            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            //////////////////////////////
            foreach (Tower t in Program.game.towers)
            {
                effect.Technique = "Light";
                effect.SetValue<SlimDX.Matrix>("matProjector", t.matProjector);

                effect.SetTexture("texLight", Program.game.renderer.texLight);
                effect.Begin(0);
                effect.BeginPass(0);

                //  mesh.DrawSubset(0);
                for (int i = 0; i < textures.Length; i++)
                {
                    effect.SetTexture("tex", textures[i]);
                    effect.CommitChanges();
                    mesh.DrawSubset(i);
                }

                effect.EndPass();
                effect.End();
            }
            /////////////////////////////
            effect.Technique = "Ambiant";
  //          effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.tower2.matProjector);

//            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);

            //mesh.DrawSubset(0);
            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            
            //////////////

            effect.Technique = "Simple";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            //mesh.DrawSubset(0);
            for (int i = 0; i < textures.Length; i++)
            {
                effect.SetTexture("tex", textures[i]);
                effect.CommitChanges();
                mesh.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();

            /*
            effect.Technique = "Simple";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            meshColision.DrawSubset(0);

            effect.EndPass();
            effect.End();
            */

            /////////////////////////////////////////////////////////////////////
            //      TVORA
            //////////////////////////////////////////////////////////////////////


            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.AlphaTestEnable, true);
            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.AlphaFunc, 5);
            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.AlphaRef, 128);
            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.CullMode, 1);
            effect.Technique = "LightFirst";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);
            effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.towers[0].matProjector);

            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);


            //mesh.DrawSubset(0);
            for (int i = 0; i < texturesTvora.Length; i++)
            {
                effect.SetTexture("tex", texturesTvora[i]);
                effect.CommitChanges();
                meshTvora.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            //////////////////////////////
            effect.Technique = "Light";
            foreach (Tower t in Program.game.towers)
            {
                effect.SetValue<SlimDX.Matrix>("matProjector", t.matProjector);

                effect.SetTexture("texLight", Program.game.renderer.texLight);
                effect.Begin(0);
                effect.BeginPass(0);

                //  mesh.DrawSubset(0);
                for (int i = 0; i < texturesTvora.Length; i++)
                {
                    effect.SetTexture("tex", texturesTvora[i]);
                    effect.CommitChanges();
                    meshTvora.DrawSubset(i);
                }

                effect.EndPass();
                effect.End();
            }
            /////////////////////////////
            effect.Technique = "Ambiant";
            //          effect.SetValue<SlimDX.Matrix>("matProjector", Program.game.tower2.matProjector);

            //            effect.SetTexture("texLight", Program.game.renderer.texLight);
            effect.Begin(0);
            effect.BeginPass(0);

            //mesh.DrawSubset(0);
            for (int i = 0; i < texturesTvora.Length; i++)
            {
                effect.SetTexture("tex", texturesTvora[i]);
                effect.CommitChanges();
                meshTvora.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();

            //////////////

            effect.Technique = "Simple";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            //mesh.DrawSubset(0);
            for (int i = 0; i < texturesTvora.Length; i++)
            {
                effect.SetTexture("tex", texturesTvora[i]);
                effect.CommitChanges();
                meshTvora.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.AlphaTestEnable, false);
            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.CullMode, 3);

/*
            effect.Technique = "Simple";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            meshColision.DrawSubset(0);

            effect.EndPass();
            effect.End();
            */

            effect.Technique = "Kalnai";
            effect.SetValue<SlimDX.Matrix>("matWorldViewProj", mat * Program.game.camera.matView * Program.game.camera.matProj);

            effect.SetTexture("tex", tex);
            effect.Begin(0);
            effect.BeginPass(0);

            //mesh.DrawSubset(0);
            for (int i = 0; i < texturesKalnai.Length; i++)
            {
                effect.SetTexture("tex", texturesKalnai[i]);
                effect.CommitChanges();
                meshKalnai.DrawSubset(i);
            }

            effect.EndPass();
            effect.End();
            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.AlphaTestEnable, false);
            effect.Device.SetRenderState(SlimDX.Direct3D9.RenderState.CullMode, 3);

        
        }


    }
}
