var mazeArray = new Array(20*20);

public var wallPrefab : Transform = null;

function CreateMaze()
{
	var dx = [ 0, 0, -1, 1 ];
	var dy = [ -1, 1, 0, 0 ];
	
	var todo = new Array(20*20);
	
	var x : int;
	var y : int;
	var d : int;
	var todoNum : int = 0;
	var n : int;
	var tx : int;
	var ty : int;
	
	for(x=0;x<20;++x)
	{
		for(y=0;y<20;++y)
		{
			if( x == 0 || x == 19 || y == 0 || y == 19 )
			{
				mazeArray[y*20+x] = 32;
			}
			else
			{
				mazeArray[y*20+x] = 63;
			}
		}
	}
	
	x = 1 + Random.value * 18;
	y = 1 + Random.value * 18;
	
	mazeArray[y*20+x] &= ~48;
	
	for(d=0;d<4;++d)
	{
		if((mazeArray[(y+dy[d])*20+(x+dx[d])] & 16) != 0 )
		{
			todo[todoNum++] = ((x + dx[d]) << 16 | (y + dy[d]));
			mazeArray[(y+dy[d])*20+x+dx[d]] &= ~16;
		}
	}
	
	//while( false )
	while( todoNum > 0 )
	{
		n = Random.value * todoNum;
		tx = todo[n];
		ty = todo[n];
		x = tx >> 16;
		y = ty & 65535;
		
		todo[n] = todo[--todoNum];
		
		d = Random.value * 4;
		while( (mazeArray[(y+dy[d])*20+(x+dx[d])] & 32) != 0 )
		{
			d = Random.value * 4;
		}
	
		mazeArray[y*20+x] &= ~((1 << d) | 32);
		mazeArray[(y+dy[d])*20+x+dx[d]] &= ~(1 << (d && 1));
	
		for(d=0;d<4;++d)
		{
			if( (mazeArray[(y+dy[d])*20+x+dx[d]] & 16) != 0)
			{
				todo[todoNum++] = (x+dx[d]) << 16 | y+dy[d];
				mazeArray[(y+dy[d])*20+x+dx[d]] &= ~16;
			}
		}
	}
	
	mazeArray[20+1] &= ~1;
	mazeArray[20*19-1] &= ~2;
}

function CreateWalls()
{
	var x : int;
	var y : int;
	var v : Vector3;
	
	var r1 : Quaternion;
	var r2 : Quaternion;
	var r3 : Quaternion;
	var r4 : Quaternion;
	
	r1.SetLookRotation( Vector3.right );
	r2.SetLookRotation( Vector3.right );
	r3.SetLookRotation( Vector3.forward );
	r4.SetLookRotation( Vector3.forward );
	
	for(x=1;x<19;++x)
	{
		for(y=1;y<19;++y)
		{
			v.x = x*4-40;
			v.y = 1.5;
			v.z = y*4-40;
			if( (mazeArray[y*20+x] & 1) != 0 )
			{
			    v.x -= 1.5;
				Instantiate( wallPrefab, v, r1 );
				v.x += 1.5;
			}
			if( (mazeArray[y*20+x] & 2) != 0 )
			{
				v.x += 1.5;
				Instantiate( wallPrefab, v, r2 );
				v.x -= 1.5;
			}
			if( (mazeArray[y*20+x] & 4) != 0 )
			{
				v.z -= 1.5;
				Instantiate( wallPrefab, v, r3 );
				v.z += 1.5;
			}
			if( (mazeArray[y*20+x] & 8) != 0 )
			{
				v.z += 1.5;
				Instantiate( wallPrefab, v, r4 );
				v.z -= 1.5;
			}
		}
	}
}

function Awake ()
{
	// penis & poonanee
	CreateMaze();
	CreateWalls();
}