vec4 Ambient;
vec4 Diffuse;
vec4 Specular;

varying vec2    vTexCoord;
varying float   fLandCof;
varying vec2	vLandPos;

void pointLight(in int i, in vec3 normal, in vec3 eye, in vec3 ecPosition3)
{
    float nDotVP;         
    float nDotHV;      
    float pf;               
    float attenuation;    
    float d;                  
    vec3  VP;             
    vec3  halfVector;   

    VP = vec3 (gl_LightSource[0].position) - ecPosition3;

    d = length(VP);

    VP = normalize(VP);

    attenuation = 1.0 / (gl_LightSource[0].constantAttenuation +
                    gl_LightSource[0].linearAttenuation * d +
                    gl_LightSource[0].quadraticAttenuation * d * d);
    halfVector = normalize(VP + eye);
    nDotVP = max(0.0, dot(normal, VP));
    nDotHV = max(0.0, dot(normal, halfVector));

    if (nDotVP == 0.0)
        pf = 0.0;
    else
        pf = pow(nDotHV, gl_FrontMaterial.shininess);

    Ambient  += gl_LightSource[0].ambient * attenuation;
    Diffuse  += gl_LightSource[0].diffuse * nDotVP * attenuation;
    Specular += gl_LightSource[0].specular * pf * attenuation;
}

vec3 fnormal(void)
{
    return  gl_NormalMatrix * gl_Normal;
}

void flight(in vec3 normal, in vec4 ecPosition)
{
    vec4 color;
    vec3 ecPosition3;
    vec3 eye;

    ecPosition3 = (vec3 (ecPosition)) / ecPosition.w;
    eye = vec3 (0.0, 0.0, 1.0);

    // Clear the light intensity accumulators
    Ambient  = vec4 (0.0);
    Diffuse  = vec4 (0.0);
    Specular = vec4 (0.0);

    pointLight(0, normal, eye, ecPosition3);

    color = gl_FrontLightModelProduct.sceneColor +
                Ambient  * gl_FrontMaterial.ambient +
                Diffuse  * gl_FrontMaterial.diffuse;
    color += Specular * gl_FrontMaterial.specular;
    color = clamp( color, 0.0, 1.0 );
    gl_FrontColor = color;
   
}  

void main(void)
{
	vTexCoord = gl_MultiTexCoord0.xy;

	// Eye-coordinate position of vertex, needed in various calculations
	vec4 ecPosition = gl_ModelViewMatrix * gl_Vertex;
	vLandPos        = gl_Vertex.xy;

	// Do fixed functionality vertex transform
	gl_Position = ftransform();

	flight(fnormal(), ecPosition);
	fLandCof = max(gl_Color.x,max(gl_Color.y,gl_Color.z));
	 gl_FrontColor.a = gl_Color.a;
}

	
