#ifndef BILLBOARD2_H
#define BILLBOARD2_H

#include "Camera/Camera.h"
#include "Types/Quaternion.h"

inline void		DrawBillBoard(const Vector3D& vPosition,float fScale,float fRotation,float alpha,float br = 1.0f)
{
	Vector3D rt = g_cMainCam.GetRightVec()*fScale;
	Vector3D up = g_cMainCam.GetUpVec()*fScale;
	Quaternion qRot(fRotation,g_cMainCam.GetLookVec());

	glColor4f(br,br,br,alpha);
	glBegin(GL_QUADS);
	glTexCoord2f(0,0);
	glVertex3fv(vPosition-rt+up);
	glTexCoord2f(0,1);
	glVertex3fv(vPosition-rt-up);
	glTexCoord2f(1,1);
	glVertex3fv(vPosition+rt-up);
	glTexCoord2f(1,0);
	glVertex3fv(vPosition+rt+up);
	glEnd();
}

#endif