#include "ChaseCamera.h"

#include "Camera/Camera.h"

#include "ErrorCheck.h"

ChaseCamera::ChaseCamera() 
:m_vSmartEye(Vector3D(0,0,0))
,m_vSmartAt(Vector3D(0,0,0))
,m_pTarget(0)
,m_nTrackDist(100.0f)
,m_nTrackDeltaZ(10.0f)
,m_nTrackSpeed(200.0f)
{
	m_eCamType = CT_FOLLOW;

}


void ChaseCamera::Update(float fDeltaTime)
{
 
	switch(m_eCamType)
	{
	case CT_UP:
		
		g_cMainCam.PositionCamera(*(m_pTarget)+Vector3D(1,1,150),*(m_pTarget),Vector3D(0,0,1));
		break;
	case CT_FOLLOW:
		// update the ChaseCamera properties
		if (m_pTarget)
		{
			Vector3D vIdealPos = *(m_pTarget) + Vector3D(0.0, 0.0, m_nTrackDeltaZ);
			if(vIdealPos.length()<450)
			{
				vIdealPos.normalize();vIdealPos *= 450.0f;
			}
			Vector3D vDelta = vIdealPos - m_vSmartEye;

			if (vDelta.length() > m_nTrackSpeed * fDeltaTime)
			{
				if(vDelta.length()>0)
					vDelta = (m_nTrackSpeed * fDeltaTime / vDelta.length()) * vDelta;
			}

			m_vSmartEye += vDelta;

			// make sure we're away from the object
	        
			vDelta = m_vSmartEye - (*(m_pTarget) + Vector3D(0.0, 0.0, m_nTrackDeltaZ));
			if (vDelta.length() < m_nTrackDist )
			{
				if(vDelta.length()>0)
						vDelta = (m_nTrackDist / vDelta.length()) * vDelta;
				m_vSmartEye = (*(m_pTarget) + Vector3D(0.0, 0.0, m_nTrackDeltaZ)) + vDelta;
			}

			m_vSmartAt=*(m_pTarget) ;

			Vector3D vViewDist=m_vSmartEye-m_vSmartAt;
			vViewDist.normalize();
			m_vSmartAt=m_vSmartEye-vViewDist;

		}

	   
		g_cMainCam.PositionCamera(m_vSmartEye,m_vSmartAt,Vector3D(0,0,1));
		break;
	}

}

void ChaseCamera::SwitchCamType()
{
	m_eCamType = ECameraType((int(m_eCamType)+1)%CT_COUNT);
}


void ChaseCamera::SetSpeed(const float& _fSpeed)
{
    m_nTrackSpeed=_fSpeed;
}
void ChaseCamera::SetSmartEye(const Vector3D &_vSmartEye)
{
    m_vSmartEye=_vSmartEye;
}
void ChaseCamera::SetSmartAt(const Vector3D &_vSmartAt)
{
    m_vSmartAt = _vSmartAt;

}
void ChaseCamera::SetTrackObject	(Vector3D * pTarget,const float& _fDist,const float&  _fDeltaZ, const float&  _fSpeed)
{
    m_pTarget = pTarget;
    m_nTrackDist	= _fDist;
    m_nTrackDeltaZ  = _fDeltaZ;
    m_nTrackSpeed   = _fSpeed;
}
void ChaseCamera::SetTrackObject	(Vector3D * pTarget)
{
    m_pTarget = pTarget;
	m_vSmartEye = g_cMainCam.GetEye();
}

