#ifndef CHASECAMERA_H
#define CHASECAMERA_H

#include "Types/Vector3D.h"

class ChaseCamera
{
public:
	enum ECameraType
	{
		CT_UP,
		CT_FOLLOW,
		CT_FREE,
		CT_COUNT
	};
private:
	ECameraType	m_eCamType;
public:
		ChaseCamera();

		void		Update(float fDeltaTime);

		void		SwitchCamType();

		//Set	important info
		void		SetSpeed		(const float& _fSpeed);
		void		SetSmartEye		(const Vector3D &_vSmartEye);
		void		SetSmartAt		(const Vector3D &_vSmartAt);
		void		SetTrackObject	(Vector3D * pTarget,const float& _fDist,const float&  _fDeltaZ, const float&  _fSpeed);
		void		SetTrackObject	(Vector3D * pTarget);

		const		Vector3D & GetSmartAt () const  { return m_vSmartAt;}
		const		Vector3D & GetSmartEye() const  { return m_vSmartEye;}
private:
		Vector3D     m_vSmartEye;								//Position of track camera
		Vector3D     m_vSmartAt;									//At what we are looking					
		Vector3D *m_pTarget;							//Position, we're tracking
		float		  m_nTrackDist, m_nTrackDeltaZ, m_nTrackSpeed;//How far we must be from target pos, delta z, how fast we're tracking
};

#endif

