#ifndef CODEAPP_HPP
#define CODEAPP_HPP

#include "MainFiles\OpenGLWnd.h"
#include "PointCamera.h"
#include "ChaseCamera.h"
#include "Pool.h"

class Planet;
class Tank;
class Rocket;
class Smoke;
class Trail;
class CTexture;

class Defcon3D:public OpenGLWnd
{
	static const int _nMaxTanks = 2;

private:
	enum EState
	{
		STATE_NONE,
		STATE_TITLE,
		STATE_PLAYER1_TURN,
		STATE_PLAYER2_TURN,
		STATE_PLAYER1_FIRING,
		STATE_PLAYER2_FIRING,
		STATE_PLAYER1_VICTORY,
		STATE_PLAYER2_VICTORY,
		STATE_RESTART
	};


private:
	Planet		   			*m_pPlanet;
	Tank		   			*m_pTanks[_nMaxTanks]; 
	Tank					*m_pTargetTank;
	Rocket		   			**m_pRocket;
	PointCamera				m_cPointCamera;
	ChaseCamera				m_cChaseCamera;

	uint					m_nRocketCnt;
	uint					m_nMaxSmokeSpawns;
	typedef Pool<Smoke>		SmokeEmitterPool;
	
	SmokeEmitterPool*		m_pSmokeEmitters;
	Trail*					m_pTrail;

	EState					m_eState;

	Vector3D				m_vRocketsMidPos;

	int						m_nSndFire;
	int						m_nSndExplosion[2];
	int						m_nSndRocket;


	int						m_nSndFireSrc;
	int						m_nSndExplosionSrc[2];
	int						m_nSndRocketSrc;
	
	bool					m_bSwitchingState;
	EState					m_eTargetState;
	float					m_fFadeValue;
	float					m_fWaitForExplosion;

	int						m_nScores[2];

	CTexture			   *m_pPlayer1,*m_pPlayer2,*m_pPower,*m_pInstructions;

	CTexture			   *m_pVic1,*m_pVic2;
	
	float					m_fPower;

	float					m_fTime;


private:
	void			CalculateScores();
	bool			AreRocketsDead();
public:
	Defcon3D();
	~Defcon3D();

	virtual bool	InitManagers();
	virtual void	DeInitManagers();
	//Resources
	virtual bool	LoadResources();
	virtual void	UnLoadResources();	
	//Settings
	virtual void	LoadSettings();
	virtual void	SaveSettings();

	//CheckInput
	virtual void	CheckInput();
	//Update
	virtual void	Update(float nDeltaTime);
	//Rendering
	virtual void	PreRender();
	virtual void	RenderStaticScene();					
	virtual void	RenderDynamicScene();				
	virtual void	PostRender();

	void			SetState(EState eState,bool withFade=true);


};


#endif