#include "Planet.h"
#include "Managers/CModelManager.hpp"
#include "Utils/Font.h"
#include "Models/CModelUtils.hpp"
#include "Utils/CVBOBuffer.h"
#include "Platform/Platform.h"
#include "DefconSettings.h"

#include "ErrorCheck.h"

Planet::Planet()
{
	m_pPlanet = g_pcModelMan->LoadModel("Planet.tct");
}
Planet::~Planet()
{
}

void Planet::Reset()
{
	CVBOBuffer *pVBO = ((CRenderDataVBO*) (m_pPlanet->GetRenderData(0)))->GetBuffer();

	uint		 count = pVBO->GetVertexCount();
	Vector3D	*verts = pVBO->GetVerticesPtr();
	Vector4D	*colors = pVBO->GetColorsPtr();

	for(uint i=0;i<count;i++)
	{
		verts[i].normalize();
		verts[i] = verts[i]*100.0f;
		colors[i].w = 1.0f;
	}

	CalcNormals();

	pVBO->UpdateVertexBuffer();
	pVBO->UpdateColorsBuffer();

	m_nCorrection[0]  = GetPlayerOneLand(true)*3/10;
	m_nCorrection[1]  = GetPlayerOneLand(true)*3/10;

	m_nMaxScore[0] = GetPlayerOneLand(true)-m_nCorrection[0];
	m_nMaxScore[1] = GetPlayerTwoLand(true)-m_nCorrection[1];
}

bool	Planet::FindRaySphereColllision(const Vector3D& vOrg,
								const Vector3D& vDir,
								const Vector3D& vCenter,
								const float fRadius,
								float &t1,
								float &t2)
{

	Vector3D e = vCenter - vOrg;
	float   a = Dot(e,vDir);

	float fSq = fRadius*fRadius-Dot(e,e)+a*a;
	
	if(fSq<0.0f)return false;

	float f = sqrtf(fSq);
	t1 = a - f;
	t2 = t1 + f + f;

	return true;
}
void Planet::CalcNormals()
{
	CVBOBuffer *pVBO = ((CRenderDataVBO*) (m_pPlanet->GetRenderData(0)))->GetBuffer();

	//Recalculate normals
	Vector3D	*normals = pVBO->GetNormalsPtr();
	Vector3D	*verts = pVBO->GetVerticesPtr();
	uint		normCount = pVBO->GetNormalCount();

	for(uint i=0;i<normCount;i++)
	{
		normals[i] = Vector3D(0,0,0);
	}
	uint		count = pVBO->GetVertexCount();

	for(uint i=0;i<count;i+=3)
	{
		uint i1 = i;
		uint i2 = i+1;
		uint i3 = i+2;
		if(i1==i2 || i2==i3 || i1==i3)continue;
		
		Vector3D v1 = verts[i1];
		Vector3D v2 = verts[i2];
		Vector3D v3 = verts[i3];
	
		Vector3D vResult;
		Vector3D vv1=v2-v1;vv1.normalize();
		Vector3D vv2=v3-v1;vv2.normalize();
		vResult=Cross(vv1,vv2);
		vResult.normalize();
		ASSERT_EXP(i1<normCount && i2<normCount && i3<normCount);
		normals[i1]+=vResult;
		normals[i2]+=vResult;
		normals[i3]+=vResult;
	}


	/*
	for(uint i=0;i<count;i++)
	for(uint j=i+1;j<count;j++)
	{
		if(Vector3D(verts[i]-verts[j]).lengthSq()<0.1f)
		{
			Vector3D sum = normals[i]+normals[j];
			normals[i] = sum;
			normals[j] = sum;
		}
	}
	*/

	for(uint i=0;i<normCount;i++)
	{
		normals[i].normalize();
	}

	pVBO->UpdateNormalsBuffer();

}


void Planet::OnHit(const Vector3D& vOrigin,const Vector3D& vDirection)
{

	float t1,t2;

	if(FindRaySphereColllision(vOrigin,vDirection,Vector3D(0,0,0),100,t1,t2))
	{
		Vector3D colPoint = vOrigin+vDirection*t1;
		CVBOBuffer *pVBO = ((CRenderDataVBO*) (m_pPlanet->GetRenderData(0)))->GetBuffer();

		Vector3D	*verts = pVBO->GetVerticesPtr();
		Vector4D	*colors = pVBO->GetColorsPtr();
		uint		count = pVBO->GetVertexCount();
		uint		colorCnt = pVBO->GetColorCount();
		const float _fMaxDistSq = Defcon::fDamageRadius*Defcon::fDamageRadius;
		const float _fDestroPower = Defcon::fDamageDepth;
		const float _fRadius  = 100.0f;
		for(uint i=0;i<count;i++)
		{
			float dist = Vector3D(verts[i]-colPoint).lengthSq();
			if(dist<_fMaxDistSq)
			{
				float t = dist/_fMaxDistSq;
				Vector3D vDestroDir = verts[i]; vDestroDir.normalize();
				verts[i]+=vDestroDir*sinf(t*PI+PI)*_fDestroPower*(1-t);
				colors[i].w = fClamp(colors[i].w*0.8f,0.4f,1.0f);
				//float len = verts[i].length();
				//if(len<_fRadius-_fFalloff) len = _fRadius-_fFalloff;
				//if(len>_fRadius+_fFalloff) len = _fRadius+_fFalloff;

				//verts[i] = verts[i].normalize();
				//verts[i]*= len;
			}
		}

	
		pVBO->UpdateVertexBuffer();
		pVBO->UpdateColorsBuffer();

		CalcNormals();
	}
}

void Planet::Render()
{
	m_pPlanet->Render();
}

int	Planet::GetPlayerOneLand(bool bTrueValue)const
{
	CVBOBuffer *pVBO = ((CRenderDataVBO*) (m_pPlanet->GetRenderData(0)))->GetBuffer();
	Vector4D	*colors = pVBO->GetColorsPtr();
	uint		colorCnt = pVBO->GetColorCount();
	int			nCnt = 0;
	for(uint i=0;i<colorCnt;i++)
	{
		if(colors[i].x>0.9f && colors[i].w>0.9f)nCnt++;
	}
	if(bTrueValue)return nCnt;

	return iClamp((nCnt-m_nCorrection[0])*100/m_nMaxScore[0],0,100);

}
int	Planet::GetPlayerTwoLand(bool bTrueValue)const
{
	CVBOBuffer *pVBO = ((CRenderDataVBO*) (m_pPlanet->GetRenderData(0)))->GetBuffer();
	Vector4D	*colors = pVBO->GetColorsPtr();
	uint		colorCnt = pVBO->GetColorCount();
	int			nCnt = 0;
	for(uint i=0;i<colorCnt;i++)
	{
		if(colors[i].y>0.9f && colors[i].w>0.9f)nCnt++;
	}

	if(bTrueValue)return nCnt;
	return iClamp((nCnt-m_nCorrection[1])*100/m_nMaxScore[1],0,100);
}