#ifndef PLANET_H
#define PLANET_H

#include "Types/Vector3D.h"

class CModel;

class Planet
{
	CModel			*m_pPlanet;

	int				m_nMaxScore[2];
	int				m_nCorrection[2];
private:
	bool	FindRaySphereColllision(const Vector3D& vOrg,
								const Vector3D& vDir,
								const Vector3D& vCenter,
								const float fRadius,
								float &t1,
								float &t2);

	void	CalcNormals();
public:
	Planet();
	~Planet();

	void			Reset();

	void			OnHit(const Vector3D& vOrigin,const Vector3D& vDirection);

	void			Render();

	int				GetPlayerOneLand(bool bTrueValue=false)const;
	int				GetPlayerTwoLand(bool bTrueValue=false)const;
};

#endif