#include "PointCamera.h"
#include "Utils/CMouseState.h"
#include "Camera/Camera.h"

#include "ErrorCheck.h"

PointCamera::PointCamera()
{
	m_qRot = Quaternion(0,0,0,1);
	m_vTarget = Vector3D(0,0,0);
	m_vView   = Vector3D(1,0,0);
}
void PointCamera::SetTarget(const Vector3D& vTarget, const Vector3D& vEye)
{
	m_vTarget = vTarget;
	m_vView = vEye-vTarget;

	g_cMainCam.PositionCamera(m_vTarget+m_vView,m_vTarget,g_cMainCam.GetUpVec());
	
}
void PointCamera::Update(float fDeltaTime)
{
	int x,y;
	g_cMouse.GetDeltaCoord(x,y);

	SimulateUserInput(-float(x)*0.01f,float(y)*0.01f);
}
void	PointCamera::SimulateUserInput(float fMouseMoveRt,float fMouseMoveUp)
{
	Quaternion qRightRot(fMouseMoveRt,g_cMainCam.GetUpVec());
	m_vView = qRightRot.rotate(m_vView);
	Quaternion qUpRot(fMouseMoveUp,g_cMainCam.GetRightVec());
	m_vView = qUpRot.rotate(m_vView);

	g_cMainCam.PositionCamera(m_vTarget+m_vView,m_vTarget,g_cMainCam.GetUpVec());
	
}
