#ifndef POINTCAMERA_H
#define POINTCAMERA_H

#include "Types/Quaternion.h"
#include "Types/Vector3D.h"

class PointCamera
{
	Quaternion		m_qRot;

	Vector3D		m_vTarget;
	Vector3D		m_vView;
public:
	PointCamera();

	void			SetTarget(const Vector3D& vTarget, const Vector3D& vEye);

	void			Update(float fDeltaTime);

	void			SimulateUserInput(float fMouseMoveRt,float fMouseMoveUp);
};


#endif